/*! JointJS v3.7.1 (2023-04-28) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
if(function(t,n){"object"==typeof exports&&"undefined"!=typeof module?module.exports=n():"function"==typeof define&&define.amd?define(n):(t=t||self).V=n()}(this,function(){"use strict";var e=Math.round,i=Math.floor,r=Math.PI,a=function(t){return t%360+(t<0?360:0)},s=function(t,n){return n*e(t/n)},c=function(t){return 180*t/r%360},l=function(t,n){return(t=(n=n||!1)?t:t%360)*r/180},o=function(t,n){if(void 0===n)n=void 0===t?1:t,t=0;else if(n<t){var e=t;t=n,n=e}return i(Math.random()*(n-t+1)+t)},f=Math.cos,d=Math.sin,g=Math.atan2,n=function(t,n){var e=l(t.y),i=l(n.y),r=t.x,s=n.x,o=l(s-r),a=d(o)*f(i),h=f(e)*d(i)-d(e)*f(i)*f(o),u=c(g(a,h))-22.5;return u<0&&(u+=360),["NE","E","SE","S","SW","W","NW","N"][u=parseInt(u/45)]},h=function(t,n){var e=t.x,i=t.y;return(e-=n.x)*e+(i-=n.y)*i},u=function(t,n){return Math.sqrt(h(t,n))},v={Point:1,Line:2,Ellipse:3,Rect:4,Polyline:5,Polygon:6,Curve:7,Path:8},p=Math.abs,m=Math.cos,y=Math.sin,x=Math.sqrt,w=Math.min,b=Math.max,S=Math.atan2,P=Math.round,A=Math.pow,T=Math.PI,L=function(t,n){if(!(this instanceof L))return new L(t,n);if("string"==typeof t){var e=t.split(-1===t.indexOf("@")?" ":"@");t=parseFloat(e[0]),n=parseFloat(e[1])}else Object(t)===t&&(n=t.y,t=t.x);this.x=void 0===t?0:t,this.y=void 0===n?0:n};L.fromPolar=function(t,n,e){e=new L(e);var i=p(t*m(n)),r=p(t*y(n)),s=a(c(n));return s<90?r=-r:s<180?(i=-i,r=-r):s<270&&(i=-i),new L(e.x+i,e.y+r)},L.random=function(t,n,e,i){return new L(o(t,n),o(e,i))},L.prototype={type:v.Point,chooseClosest:function(t){var n=t.length;if(1===n)return new L(t[0]);for(var e=null,i=1/0,r=0;r<n;r++){var s=new L(t[r]),o=this.squaredDistance(s);o<i&&(e=s,i=o)}return e},adhereToRect:function(t){return t.containsPoint(this)||(this.x=w(b(this.x,t.x),t.x+t.width),this.y=w(b(this.y,t.y),t.y+t.height)),this},angleBetween:function(t,n){var e=this.equals(t)||this.equals(n)?NaN:this.theta(n)-this.theta(t);return e<0&&(e+=360),e},bearing:function(t){return n(this,t)},changeInAngle:function(t,n,e){return this.clone().offset(-t,-n).theta(e)-this.theta(e)},clone:function(){return new L(this)},cross:function(t,n){return t&&n?(n.x-this.x)*(t.y-this.y)-(n.y-this.y)*(t.x-this.x):NaN},difference:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),new L(this.x-(t||0),this.y-(n||0))},distance:function(t){return u(this,t)},dot:function(t){return t?this.x*t.x+this.y*t.y:NaN},equals:function(t){return!!t&&this.x===t.x&&this.y===t.y},lerp:function(t,n){var e=this.x,i=this.y;return new L((1-n)*e+n*t.x,(1-n)*i+n*t.y)},magnitude:function(){return x(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(t){return p(t.x-this.x)+p(t.y-this.y)},move:function(t,n){var e=l(new L(t).theta(this));return this.offset(m(e)*n,-y(e)*n)},normalize:function(t){var n=(t||1)/this.magnitude();return this.scale(n,n)},offset:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),this.x+=t||0,this.y+=n||0,this},reflection:function(t){return new L(t).move(this,this.distance(t))},rotate:function(t,n){if(0===n)return this;t=t||new L(0,0),n=l(a(-n));var e=m(n),i=y(n),r=e*(this.x-t.x)-i*(this.y-t.y)+t.x,s=i*(this.x-t.x)+e*(this.y-t.y)+t.y;return this.x=r,this.y=s,this},round:function(t){var n=1;if(t)switch(t){case 1:n=10;break;case 2:n=100;break;case 3:n=1e3;break;default:n=A(10,t)}return this.x=P(this.x*n)/n,this.y=P(this.y*n)/n,this},scale:function(t,n,e){return e=e&&new L(e)||new L(0,0),this.x=e.x+t*(this.x-e.x),this.y=e.y+n*(this.y-e.y),this},snapToGrid:function(t,n){return this.x=s(this.x,t),this.y=s(this.y,n||t),this},squaredDistance:function(t){return h(this,t)},theta:function(t){var n=-((t=new L(t)).y-this.y),e=t.x-this.x,i=S(n,e);return i<0&&(i=2*T+i),180*i/T},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(t){t=t&&new L(t)||new L(0,0);var n=this.x,e=this.y;return this.x=x((n-t.x)*(n-t.x)+(e-t.y)*(e-t.y)),this.y=l(t.theta(new L(n,e))),this},toString:function(){return this.x+"@"+this.y},serialize:function(){return this.x+","+this.y},update:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),this.x=t||0,this.y=n||0,this},vectorAngle:function(t){return new L(0,0).angleBetween(this,t)}},L.prototype.translate=L.prototype.offset;var t=L,E=Math.max,C=Math.min,N=function(t,n){return this instanceof N?t instanceof N?new N(t.start,t.end):(this.start=new L(t),void(this.end=new L(n))):new N(t,n)};N.prototype={type:v.Line,angle:function(){var t=new L(this.start.x+1,this.start.y);return this.start.angleBetween(this.end,t)},bbox:function(){var t=C(this.start.x,this.end.x),n=C(this.start.y,this.end.y),e=E(this.start.x,this.end.x),i=E(this.start.y,this.end.y);return new B(t,n,e-t,i-n)},bearing:function(){return n(this.start,this.end)},clone:function(){return new N(this.start,this.end)},closestPoint:function(t){return this.pointAt(this.closestPointNormalizedLength(t))},closestPointLength:function(t){return this.closestPointNormalizedLength(t)*this.length()},closestPointNormalizedLength:function(t){var n=this.vector().dot(new N(this.start,t).vector()),e=C(1,E(0,n/this.squaredLength()));return e!=e?0:e},closestPointTangent:function(t){return this.tangentAt(this.closestPointNormalizedLength(t))},containsPoint:function(t){var n=this.start,e=this.end;if(0!==n.cross(t,e))return!1;var i=this.length();return!(new N(n,t).length()>i)&&!(new N(t,e).length()>i)},divideAt:function(t){var n=this.pointAt(t);return[new N(this.start,n),new N(n,this.end)]},divideAtLength:function(t){var n=this.pointAtLength(t);return[new N(this.start,n),new N(n,this.end)]},equals:function(t){return!!t&&this.start.x===t.start.x&&this.start.y===t.start.y&&this.end.x===t.end.x&&this.end.y===t.end.y},intersect:function(t,n){if(t&&t.intersectionWithLine){var e=t.intersectionWithLine(this,n);return e&&t instanceof N&&(e=e[0]),e}return null},intersectionWithLine:function(t){var n=new L(this.end.x-this.start.x,this.end.y-this.start.y),e=new L(t.end.x-t.start.x,t.end.y-t.start.y),i=n.x*e.y-n.y*e.x,r=new L(t.start.x-this.start.x,t.start.y-this.start.y),s=r.x*e.y-r.y*e.x,o=r.x*n.y-r.y*n.x;if(0===i||s*i<0||o*i<0)return null;if(0<i){if(i<s||i<o)return null}else if(s<i||o<i)return null;return[new L(this.start.x+s*n.x/i,this.start.y+s*n.y/i)]},isDifferentiable:function(){return!this.start.equals(this.end)},length:function(){return u(this.start,this.end)},midpoint:function(){return new L((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},parallel:function(t){var n=this.clone();if(!this.isDifferentiable())return n;var e=n.start,i=n.end,r=e.clone().rotate(i,270),s=i.clone().rotate(e,90);return e.move(s,t),i.move(r,t),n},pointAt:function(t){var n=this.start,e=this.end;return t<=0?n.clone():1<=t?e.clone():n.lerp(e,t)},pointAtLength:function(t){var n=this.start,e=this.end,i=!0;t<0&&(i=!1,t=-t);var r=this.length();return r<=t?i?e.clone():n.clone():this.pointAt((i?t:r-t)/r)},pointOffset:function(t){t=new L(t);var n=this.start,e=this.end;return((e.x-n.x)*(t.y-n.y)-(e.y-n.y)*(t.x-n.x))/this.length()},rotate:function(t,n){return this.start.rotate(t,n),this.end.rotate(t,n),this},round:function(t){return this.start.round(t),this.end.round(t),this},scale:function(t,n,e){return this.start.scale(t,n,e),this.end.scale(t,n,e),this},setLength:function(t){var n=this.length();if(!n)return this;var e=t/n;return this.scale(e,e,this.start)},squaredLength:function(){return h(this.start,this.end)},tangentAt:function(t){if(!this.isDifferentiable())return null;var n=this.start,e=this.end,i=this.pointAt(t),r=new N(n,e);return r.translate(i.x-n.x,i.y-n.y),r},tangentAtLength:function(t){if(!this.isDifferentiable())return null;var n=this.start,e=this.end,i=this.pointAtLength(t),r=new N(n,e);return r.translate(i.x-n.x,i.y-n.y),r},toString:function(){return this.start.toString()+" "+this.end.toString()},serialize:function(){return this.start.serialize()+" "+this.end.serialize()},translate:function(t,n){return this.start.translate(t,n),this.end.translate(t,n),this},vector:function(){return new L(this.end.x-this.start.x,this.end.y-this.start.y)}},N.prototype.intersection=N.prototype.intersect;var I=N,M=Math.sqrt,R=Math.round,O=Math.pow,D=function(t,n,e){return this instanceof D?t instanceof D?new D(new L(t.x,t.y),t.a,t.b):(t=new L(t),this.x=t.x,this.y=t.y,this.a=n,void(this.b=e)):new D(t,n,e)};D.fromRect=function(t){return t=new B(t),new D(t.center(),t.width/2,t.height/2)},D.prototype={type:v.Ellipse,bbox:function(){return new B(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},center:function(){return new L(this.x,this.y)},clone:function(){return new D(this)},containsPoint:function(t){return this.normalizedDistance(t)<=1},equals:function(t){return!!t&&t.x===this.x&&t.y===this.y&&t.a===this.a&&t.b===this.b},inflate:function(t,n){return void 0===t&&(t=0),void 0===n&&(n=t),this.a+=2*t,this.b+=2*n,this},intersectionWithLine:function(t){var n=[],e=t.start,i=t.end,r=this.a,s=this.b,o=t.vector(),a=e.difference(new L(this)),h=new L(o.x/(r*r),o.y/(s*s)),u=new L(a.x/(r*r),a.y/(s*s)),c=o.dot(h),l=o.dot(u),f=l*l-c*(a.dot(u)-1);if(f<0)return null;if(0<f){var d=M(f),g=(-l-d)/c,v=(-l+d)/c;if((g<0||1<g)&&(v<0||1<v))return null;0<=g&&g<=1&&n.push(e.lerp(i,g)),0<=v&&v<=1&&n.push(e.lerp(i,v))}else{var p=-l/c;if(!(0<=p&&p<=1))return null;n.push(e.lerp(i,p))}return n},intersectionWithLineFromCenterToPoint:function(t,n){t=new L(t),n&&t.rotate(new L(this.x,this.y),n);var e,i=t.x-this.x,r=t.y-this.y;if(0===i)return e=this.bbox().pointNearestToPoint(t),n?e.rotate(new L(this.x,this.y),-n):e;var s=r/i,o=s*s,a=this.a*this.a,h=this.b*this.b,u=M(1/(1/a+o/h)),c=s*(u=i<0?-u:u);return e=new L(this.x+u,this.y+c),n?e.rotate(new L(this.x,this.y),-n):e},normalizedDistance:function(t){var n=t.x,e=t.y,i=this.a,r=this.b,s=this.x,o=this.y;return(n-s)*(n-s)/(i*i)+(e-o)*(e-o)/(r*r)},round:function(t){var n=1;if(t)switch(t){case 1:n=10;break;case 2:n=100;break;case 3:n=1e3;break;default:n=O(10,t)}return this.x=R(this.x*n)/n,this.y=R(this.y*n)/n,this.a=R(this.a*n)/n,this.b=R(this.b*n)/n,this},tangentTheta:function(t){var n,e,i=t.x,r=t.y,s=this.a,o=this.b,a=this.bbox().center(),h=a.x,u=a.y,c=i>a.x+s/2,l=i<a.x-s/2;return c||l?e=s*s/(i-h)-s*s*(r-u)*((n=i>a.x?r-30:r+30)-u)/(o*o*(i-h))+h:n=o*o/(r-u)-o*o*(i-h)*((e=r>a.y?i+30:i-30)-h)/(s*s*(r-u))+u,new L(e,n).theta(t)},toString:function(){return new L(this.x,this.y).toString()+" "+this.a+" "+this.b}};var F=D,q=Math.abs,V=Math.cos,z=Math.sin,k=Math.min,j=Math.max,G=Math.round,W=Math.pow,B=function(t,n,e,i){if(!(this instanceof B))return new B(t,n,e,i);Object(t)===t&&(n=t.y,e=t.width,i=t.height,t=t.x),this.x=void 0===t?0:t,this.y=void 0===n?0:n,this.width=void 0===e?0:e,this.height=void 0===i?0:i};B.fromEllipse=function(t){return t=new D(t),new B(t.x-t.a,t.y-t.b,2*t.a,2*t.b)},B.fromPointUnion=function(){for(var t=[],n=arguments.length;n--;)t[n]=arguments[n];if(0===t.length)return null;var e,i,r,s,o=new L;e=i=1/0,r=s=-1/0;for(var a=0;a<t.length;a++){o.update(t[a]);var h=o.x,u=o.y;h<e&&(e=h),r<h&&(r=h),u<i&&(i=u),s<u&&(s=u)}return new B(e,i,r-e,s-i)},B.fromRectUnion=function(){for(var t=[],n=arguments.length;n--;)t[n]=arguments[n];if(0===t.length)return null;var e,i,r,s,o=new B;e=i=1/0,r=s=-1/0;for(var a=0;a<t.length;a++){o.update(t[a]);var h=o.x,u=o.y,c=h+o.width,l=u+o.height;h<e&&(e=h),r<c&&(r=c),u<i&&(i=u),s<l&&(s=l)}return new B(e,i,r-e,s-i)},B.prototype={type:v.Rect,bbox:function(t){return this.clone().rotateAroundCenter(t)},rotateAroundCenter:function(t){if(!t)return this;var n=this.width,e=this.height,i=l(t),r=q(z(i)),s=q(V(i)),o=n*s+e*r,a=n*r+e*s;return this.x+=(n-o)/2,this.y+=(e-a)/2,this.width=o,this.height=a,this},bottomLeft:function(){return new L(this.x,this.y+this.height)},bottomLine:function(){return new N(this.bottomLeft(),this.bottomRight())},bottomMiddle:function(){return new L(this.x+this.width/2,this.y+this.height)},center:function(){return new L(this.x+this.width/2,this.y+this.height/2)},clone:function(){return new B(this)},containsPoint:function(t){return(t=new L(t)).x>=this.x&&t.x<=this.x+this.width&&t.y>=this.y&&t.y<=this.y+this.height},containsRect:function(t){var n=new B(this).normalize(),e=new B(t).normalize(),i=n.width,r=n.height,s=e.width,o=e.height;if(!(i&&r&&s&&o))return!1;var a=n.x,h=n.y,u=e.x,c=e.y;return s+=u,i+=a,o+=c,r+=h,a<=u&&s<=i&&h<=c&&o<=r},corner:function(){return new L(this.x+this.width,this.y+this.height)},equals:function(t){var n=new B(this).normalize(),e=new B(t).normalize();return n.x===e.x&&n.y===e.y&&n.width===e.width&&n.height===e.height},inflate:function(t,n){return void 0===t&&(t=0),void 0===n&&(n=t),this.x-=t,this.y-=n,this.width+=2*t,this.height+=2*n,this},intersect:function(t){var n=this.origin(),e=this.corner(),i=t.origin(),r=t.corner();if(r.x<=n.x||r.y<=n.y||i.x>=e.x||i.y>=e.y)return null;var s=j(n.x,i.x),o=j(n.y,i.y);return new B(s,o,k(e.x,r.x)-s,k(e.y,r.y)-o)},intersectionWithLine:function(t){var n,e,i=[this.topLine(),this.rightLine(),this.bottomLine(),this.leftLine()],r=[],s=[],o=i.length;for(e=0;e<o;e++)null!==(n=t.intersect(i[e]))&&s.indexOf(n.toString())<0&&(r.push(n),s.push(n.toString()));return 0<r.length?r:null},intersectionWithLineFromCenterToPoint:function(t,n){t=new L(t);var e,i=new L(this.x+this.width/2,this.y+this.height/2);n&&t.rotate(i,n);for(var r=[this.topLine(),this.rightLine(),this.bottomLine(),this.leftLine()],s=new N(i,t),o=r.length-1;0<=o;--o){var a=r[o].intersection(s);if(null!==a){e=a;break}}return e&&n&&e.rotate(i,-n),e},leftLine:function(){return new N(this.topLeft(),this.bottomLeft())},leftMiddle:function(){return new L(this.x,this.y+this.height/2)},maxRectScaleToFit:function(t,n){var e,i,r,s,o,a,h,u;t=new B(t),n||(n=t.center());var c=n.x,l=n.y;e=i=r=s=o=a=h=u=1/0;var f=t.topLeft();f.x<c&&(e=(this.x-c)/(f.x-c)),f.y<l&&(o=(this.y-l)/(f.y-l));var d=t.bottomRight();d.x>c&&(i=(this.x+this.width-c)/(d.x-c)),d.y>l&&(a=(this.y+this.height-l)/(d.y-l));var g=t.topRight();g.x>c&&(r=(this.x+this.width-c)/(g.x-c)),g.y<l&&(h=(this.y-l)/(g.y-l));var v=t.bottomLeft();return v.x<c&&(s=(this.x-c)/(v.x-c)),v.y>l&&(u=(this.y+this.height-l)/(v.y-l)),{sx:k(e,i,r,s),sy:k(o,a,h,u)}},maxRectUniformScaleToFit:function(t,n){var e=this.maxRectScaleToFit(t,n);return k(e.sx,e.sy)},moveAndExpand:function(t){return this.x+=t.x||0,this.y+=t.y||0,this.width+=t.width||0,this.height+=t.height||0,this},normalize:function(){var t=this.x,n=this.y,e=this.width,i=this.height;return this.width<0&&(t=this.x+this.width,e=-this.width),this.height<0&&(n=this.y+this.height,i=-this.height),this.x=t,this.y=n,this.width=e,this.height=i,this},offset:function(t,n){return L.prototype.offset.call(this,t,n)},origin:function(){return new L(this.x,this.y)},pointNearestToPoint:function(t){if(t=new L(t),this.containsPoint(t))switch(this.sideNearestToPoint(t)){case"right":return new L(this.x+this.width,t.y);case"left":return new L(this.x,t.y);case"bottom":return new L(t.x,this.y+this.height);case"top":return new L(t.x,this.y)}return t.adhereToRect(this)},rightLine:function(){return new N(this.topRight(),this.bottomRight())},rightMiddle:function(){return new L(this.x+this.width,this.y+this.height/2)},round:function(t){var n=1;if(t)switch(t){case 1:n=10;break;case 2:n=100;break;case 3:n=1e3;break;default:n=W(10,t)}return this.x=G(this.x*n)/n,this.y=G(this.y*n)/n,this.width=G(this.width*n)/n,this.height=G(this.height*n)/n,this},scale:function(t,n,e){return e=this.origin().scale(t,n,e),this.x=e.x,this.y=e.y,this.width*=t,this.height*=n,this},sideNearestToPoint:function(t){var n=(t=new L(t)).x-this.x,e=this.x+this.width-t.x,i=t.y-this.y,r=n,s="left";return e<r&&(r=e,s="right"),i<r&&(r=i,s="top"),this.y+this.height-t.y<r&&(s="bottom"),s},snapToGrid:function(t,n){var e=this.origin().snapToGrid(t,n),i=this.corner().snapToGrid(t,n);return this.x=e.x,this.y=e.y,this.width=i.x-e.x,this.height=i.y-e.y,this},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},topLine:function(){return new N(this.topLeft(),this.topRight())},topMiddle:function(){return new L(this.x+this.width/2,this.y)},topRight:function(){return new L(this.x+this.width,this.y)},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(t){return B.fromRectUnion(this,t)},update:function(t,n,e,i){return Object(t)===t&&(n=t.y,e=t.width,i=t.height,t=t.x),this.x=t||0,this.y=n||0,this.width=e||0,this.height=i||0,this}},B.prototype.bottomRight=B.prototype.corner,B.prototype.topLeft=B.prototype.origin,B.prototype.translate=B.prototype.offset;var H=B;function U(t){var n=t.trim();if(""===n)return[];for(var e=[],i=n.split(/\b\s*,\s*|,\s*|\s+/),r=i.length,s=0;s<r;s+=2)e.push({x:+i[s],y:+i[s+1]});return e}function Z(t){var n=t.length;if(0===n)return[];for(var e=[],i=0;i<n;i++){var r=t[i].clone();e.push(r)}return e}function Y(t){var n,e,i,r=Math.abs,s=t.length;if(0===s)return[];for(n=0;n<s;n++)void 0===i?i=t[n]:t[n].y<i.y?i=t[n]:t[n].y===i.y&&t[n].x>i.x&&(i=t[n]);var o=[];for(n=0;n<s;n++){var a=i.theta(t[n]);0===a&&(a=360);var h=[t[n],n,a];o.push(h)}if(o.sort(function(t,n){var e=t[2]-n[2];return 0===e&&(e=n[1]-t[1]),e}),2<o.length){var u=o[o.length-1];o.unshift(u)}for(var c,l,f,d,g,v,p,m={},y=[];0!==o.length;)if(l=(c=o.pop())[0],!m.hasOwnProperty(c[0]+"@@"+c[1]))for(var x=!1;!x;)if(y.length<2)y.push(c),x=!0;else{d=(f=y.pop())[0];var w=(v=(g=y.pop())[0]).cross(d,l);if(w<0)y.push(g),y.push(f),y.push(c),x=!0;else if(0===w){var b=d.angleBetween(v,l);r(b-180)<1e-10?(m[f[0]+"@@"+f[1]]=d,y.push(g)):d.equals(l)||v.equals(d)?(m[f[0]+"@@"+f[1]]=d,y.push(g)):r((b+1)%360-1)<1e-10&&(y.push(g),o.push(f))}else m[f[0]+"@@"+f[1]]=d,y.push(g)}2<y.length&&y.pop();var S=-1;for(e=y.length,n=0;n<e;n++){var P=y[n][1];(void 0===p||P<p)&&(p=P,S=n)}var A=[];if(0<S){var T=y.slice(S),L=y.slice(0,S);A=T.concat(L)}else A=y;var E=[];for(e=A.length,n=0;n<e;n++)E.push(A[n][0]);return E}var X=function(t){return this instanceof X?"string"==typeof t?new X.parse(t):void(this.points=Array.isArray(t)?t.map(L):[]):new X(t)};X.parse=function(t){return new X(U(t))},X.fromRect=function(t){return new X([t.topLeft(),t.topRight(),t.bottomRight(),t.bottomLeft(),t.topLeft()])},X.prototype={type:v.Polyline,bbox:function(){var t=1/0,n=-1/0,e=1/0,i=-1/0,r=this.points,s=r.length;if(0===s)return null;for(var o=0;o<s;o++){var a=r[o],h=a.x,u=a.y;h<t&&(t=h),n<h&&(n=h),u<e&&(e=u),i<u&&(i=u)}return new B(t,e,n-t,i-e)},clone:function(){return new X(Z(this.points))},closestPoint:function(t){var n=this.closestPointLength(t);return this.pointAtLength(n)},closestPointLength:function(t){var n,e=this.lengthPoints(),i=e.length;if(0===i)return 0;if(1===i)return 0;for(var r=1/0,s=0,o=i-1,a=0;a<o;a++){var h=new N(e[a],e[a+1]),u=h.length(),c=h.closestPointNormalizedLength(t),l=h.pointAt(c).squaredDistance(t);l<r&&(r=l,n=s+c*u),s+=u}return n},closestPointNormalizedLength:function(t){var n=this.closestPointLength(t);if(0===n)return 0;var e=this.length();return 0===e?0:n/e},closestPointTangent:function(t){var n=this.closestPointLength(t);return this.tangentAtLength(n)},containsPoint:function(t){var n=this.points,e=n.length;if(0===e)return!1;for(var i=t.x,r=t.y,s=e-1,o=0,a=0,h=new N,u=new N,c=new L;o<e;o++){var l=n[s],f=n[o];if(t.equals(l))return!0;if(h.start=l,h.end=f,h.containsPoint(t))return!0;if(r<=l.y&&r>f.y||r>l.y&&r<=f.y){var d=l.x-i>f.x-i?l.x-i:f.x-i;0<=d&&(c.x=i+d,c.y=r,u.start=t,u.end=c,h.intersect(u)&&a++)}s=o}return a%2==1},close:function(){var t=this.start,n=this.end,e=this.points;return t&&n&&!t.equals(n)&&e.push(t.clone()),this},lengthPoints:function(){return this.points},convexHull:function(){return new X(Y(this.points))},equals:function(t){if(!t)return!1;var n=this.points,e=t.points,i=n.length;if(e.length!==i)return!1;for(var r=0;r<i;r++){var s=n[r],o=t.points[r];if(!s.equals(o))return!1}return!0},intersectionWithLine:function(t){for(var n=new N(t),e=[],i=this.lengthPoints(),r=new N,s=0,o=i.length-1;s<o;s++){r.start=i[s],r.end=i[s+1];var a=n.intersectionWithLine(r);a&&e.push(a[0])}return 0<e.length?e:null},isDifferentiable:function(){var t=this.points,n=t.length;if(0===n)return!1;for(var e=new N,i=n-1,r=0;r<i;r++)if(e.start=t[r],e.end=t[r+1],e.isDifferentiable())return!0;return!1},length:function(){var t=this.lengthPoints(),n=t.length;if(0===n)return 0;for(var e=0,i=n-1,r=0;r<i;r++)e+=t[r].distance(t[r+1]);return e},pointAt:function(t){var n=this.lengthPoints(),e=n.length;if(0===e)return null;if(1===e)return n[0].clone();if(t<=0)return n[0].clone();if(1<=t)return n[e-1].clone();var i=this.length()*t;return this.pointAtLength(i)},pointAtLength:function(t){var n=this.lengthPoints(),e=n.length;if(0===e)return null;if(1===e)return n[0].clone();var i=!0;t<0&&(i=!1,t=-t);for(var r=0,s=e-1,o=0;o<s;o++){var a=i?o:s-1-o,h=n[a],u=n[a+1],c=new N(h,u),l=h.distance(u);if(t<=r+l)return c.pointAtLength((i?1:-1)*(t-r));r+=l}return(i?n[e-1]:n[0]).clone()},round:function(t){for(var n=this.points,e=n.length,i=0;i<e;i++)n[i].round(t);return this},scale:function(t,n,e){for(var i=this.points,r=i.length,s=0;s<r;s++)i[s].scale(t,n,e);return this},simplify:function(t){void 0===t&&(t={});var n=this.points;if(n.length<3)return this;for(var e=t.threshold||0,i=0;n[i+2];){var r=i+1,s=i+2,o=n[i],a=n[r],h=n[s];new N(o,h).closestPoint(a).distance(a)<=e?n.splice(r,1):i+=1}return this},tangentAt:function(t){var n=this.lengthPoints().length;if(0===n)return null;if(1===n)return null;t<0&&(t=0),1<t&&(t=1);var e=this.length()*t;return this.tangentAtLength(e)},tangentAtLength:function(t){var n=this.lengthPoints(),e=n.length;if(0===e)return null;if(1===e)return null;var i,r=!0;t<0&&(r=!1,t=-t);for(var s=0,o=e-1,a=0;a<o;a++){var h=r?a:o-1-a,u=n[h],c=n[h+1],l=new N(u,c),f=u.distance(c);if(l.isDifferentiable()){if(t<=s+f)return l.tangentAtLength((r?1:-1)*(t-s));i=l}s+=f}if(i){var d=r?1:0;return i.tangentAt(d)}return null},toString:function(){return this.points+""},translate:function(t,n){for(var e=this.points,i=e.length,r=0;r<i;r++)e[r].translate(t,n);return this},serialize:function(){var t=this.points,n=t.length;if(0===n)return"";for(var e="",i=0;i<n;i++){var r=t[i];e+=r.x+","+r.y+" "}return e.trim()}},Object.defineProperty(X.prototype,"start",{configurable:!0,enumerable:!0,get:function(){return 0===this.points.length?null:this.points[0]}}),Object.defineProperty(X.prototype,"end",{configurable:!0,enumerable:!0,get:function(){var t=this.points.length;return 0===t?null:this.points[t-1]}});var J=Math.abs,K=Math.sqrt,Q=Math.min,$=Math.max,_=Math.pow,tt=function(t,n,e,i){return this instanceof tt?t instanceof tt?new tt(t.start,t.controlPoint1,t.controlPoint2,t.end):(this.start=new L(t),this.controlPoint1=new L(n),this.controlPoint2=new L(e),void(this.end=new L(i))):new tt(t,n,e,i)};function nt(t){var n,e,i=arguments,r=[];for(e=arguments.length,n=1;n<e;n++)r.push(i[n]);if(!t)throw new Error("Missing a parent object.");var s=Object.create(t);for(e=r.length,n=0;n<e;n++){var o,a,h=r[n];for(a in h)h.hasOwnProperty(a)&&(delete s[a],o=Object.getOwnPropertyDescriptor(h,a),Object.defineProperty(s,a,o))}return s}tt.throughPoints=function(){function h(t){var n=t.length,e=[],i=[],r=2;e[0]=t[0]/r;for(var s=1;s<n;s++)i[s]=1/r,r=(s<n-1?4:3.5)-i[s],e[s]=(t[s]-e[s-1])/r;for(s=1;s<n;s++)e[n-s-1]-=i[n-s]*e[n-s];return e}return function(t){if(!t||Array.isArray(t)&&t.length<2)throw new Error("At least 2 points are required");for(var n=function(t){var n,e=[],i=[],r=t.length-1;if(1==r)return e[0]=new L((2*t[0].x+t[1].x)/3,(2*t[0].y+t[1].y)/3),i[0]=new L(2*e[0].x-t[0].x,2*e[0].y-t[0].y),[e,i];var s=[];for(n=1;n<r-1;n++)s[n]=4*t[n].x+2*t[n+1].x;s[0]=t[0].x+2*t[1].x,s[r-1]=(8*t[r-1].x+t[r].x)/2;var o=h(s);for(n=1;n<r-1;++n)s[n]=4*t[n].y+2*t[n+1].y;s[0]=t[0].y+2*t[1].y,s[r-1]=(8*t[r-1].y+t[r].y)/2;var a=h(s);for(n=0;n<r;n++)e.push(new L(o[n],a[n])),n<r-1?i.push(new L(2*t[n+1].x-o[n+1],2*t[n+1].y-a[n+1])):i.push(new L((t[r].x+o[r-1])/2,(t[r].y+a[r-1])/2));return[e,i]}(t),e=[],i=n[0].length,r=0;r<i;r++){var s=new L(n[0][r].x,n[0][r].y),o=new L(n[1][r].x,n[1][r].y);e.push(new tt(t[r],s,o,t[r+1]))}return e}}(),tt.prototype={type:v.Curve,bbox:function(){for(var t,n,e,i,r,s,o,a,h=this.start,u=this.controlPoint1,c=this.controlPoint2,l=this.end,f=h.x,d=h.y,g=u.x,v=u.y,p=c.x,m=c.y,y=l.x,x=l.y,w=new Array,b=new Array,S=[new Array,new Array],P=0;P<2;++P)if(e=0===P?(n=6*f-12*g+6*p,t=-3*f+9*g-9*p+3*y,3*g-3*f):(n=6*d-12*v+6*m,t=-3*d+9*v-9*m+3*x,3*v-3*d),J(t)<1e-12){if(J(n)<1e-12)continue;0<(i=-e/n)&&i<1&&b.push(i)}else a=K(o=n*n-4*e*t),o<0||(0<(r=(-n+a)/(2*t))&&r<1&&b.push(r),0<(s=(-n-a)/(2*t))&&s<1&&b.push(s));for(var A,T,L,E=b.length,C=E;E--;)T=(A=1-(i=b[E]))*A*A*f+3*A*A*i*g+3*A*i*i*p+i*i*i*y,S[0][E]=T,L=A*A*A*d+3*A*A*i*v+3*A*i*i*m+i*i*i*x,S[1][E]=L,w[E]={X:T,Y:L};b[C]=0,b[C+1]=1,w[C]={X:f,Y:d},w[C+1]={X:y,Y:x},S[0][C]=f,S[1][C]=d,S[0][C+1]=y,S[1][C+1]=x,b.length=C+2,S[0].length=C+2,S[1].length=C+2,w.length=C+2;var N=Q.apply(null,S[0]),I=Q.apply(null,S[1]),M=$.apply(null,S[0]),R=$.apply(null,S[1]);return new B(N,I,M-N,R-I)},clone:function(){return new tt(this.start,this.controlPoint1,this.controlPoint2,this.end)},closestPoint:function(t,n){return this.pointAtT(this.closestPointT(t,n))},closestPointLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions};return this.lengthAtT(this.closestPointT(t,i),i)},closestPointNormalizedLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions},r=this.closestPointLength(t,i);if(!r)return 0;var s=this.length(i);return 0===s?0:r/s},closestPointT:function(t,n){for(var e,i,r,s,o,a,h,u=void 0===(n=n||{}).precision?this.PRECISION:n.precision,c=void 0===n.subdivisions?this.getSubdivisions({precision:u}):n.subdivisions,l=c.length,f=l?1/l:0,d=0;d<l;d++){var g=c[d],v=g.start.distance(t),p=g.end.distance(t),m=v+p;(!h||m<h)&&(i=d*f,r=(d+1)*f,s=v,o=p,a=(e=g).start.distance(g.end),h=m)}for(var y=_(10,-u);;){var x=s?J(s-o)/s:0,w=o?J(s-o)/o:0;if(x<y||w<y||(!s||s<a*y||(!o||o<a*y)))return s<=o?i:r;var b=e.divide(.5);f/=2;var S=b[0].start.distance(t),P=b[0].end.distance(t),A=S+P,T=b[1].start.distance(t),L=b[1].end.distance(t);o=A<=T+L?(e=b[0],r-=f,s=S,P):(e=b[1],i+=f,s=T,L)}},closestPointTangent:function(t,n){return this.tangentAtT(this.closestPointT(t,n))},containsPoint:function(t,n){return this.toPolyline(n).containsPoint(t)},divideAt:function(t,n){if(t<=0)return this.divideAtT(0);if(1<=t)return this.divideAtT(1);var e=this.tAt(t,n);return this.divideAtT(e)},divideAtLength:function(t,n){var e=this.tAtLength(t,n);return this.divideAtT(e)},divideAtT:function(t){var n=this.start,e=this.controlPoint1,i=this.controlPoint2,r=this.end;if(t<=0)return[new tt(n,n,n,n),new tt(n,e,i,r)];if(1<=t)return[new tt(n,e,i,r),new tt(r,r,r,r)];var s=this.getSkeletonPoints(t),o=s.startControlPoint1,a=s.startControlPoint2,h=s.divider,u=s.dividerControlPoint1,c=s.dividerControlPoint2;return[new tt(n,o,a,h),new tt(h,u,c,r)]},endpointDistance:function(){return this.start.distance(this.end)},equals:function(t){return!!t&&this.start.x===t.start.x&&this.start.y===t.start.y&&this.controlPoint1.x===t.controlPoint1.x&&this.controlPoint1.y===t.controlPoint1.y&&this.controlPoint2.x===t.controlPoint2.x&&this.controlPoint2.y===t.controlPoint2.y&&this.end.x===t.end.x&&this.end.y===t.end.y},getSkeletonPoints:function(t){var n=this.start,e=this.controlPoint1,i=this.controlPoint2,r=this.end;if(t<=0)return{startControlPoint1:n.clone(),startControlPoint2:n.clone(),divider:n.clone(),dividerControlPoint1:e.clone(),dividerControlPoint2:i.clone()};if(1<=t)return{startControlPoint1:e.clone(),startControlPoint2:i.clone(),divider:r.clone(),dividerControlPoint1:r.clone(),dividerControlPoint2:r.clone()};var s=new N(n,e).pointAt(t),o=new N(e,i).pointAt(t),a=new N(i,r).pointAt(t),h=new N(s,o).pointAt(t),u=new N(o,a).pointAt(t);return{startControlPoint1:s,startControlPoint2:h,divider:new N(h,u).pointAt(t),dividerControlPoint1:u,dividerControlPoint2:a}},getSubdivisions:function(t){var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=this.start,i=this.controlPoint1,r=this.controlPoint2,s=this.end,o=[new tt(e,i,r,s)];if(0===n)return o;if(!this.isDifferentiable())return o;var a=this.endpointDistance(),h=_(10,-n),u=2;0===i.cross(e,s)&&0===r.cross(e,s)&&(u=2*n);for(var c=0;;){c+=1;for(var l=[],f=o.length,d=0;d<f;d++){var g=o[d].divide(.5);l.push(g[0],g[1])}for(var v=0,p=l.length,m=0;m<p;m++){v+=l[m].endpointDistance()}if(u<=c)if((0!==v?(v-a)/v:0)<h)return l;o=l,a=v}},isDifferentiable:function(){var t=this.start,n=this.controlPoint1,e=this.controlPoint2,i=this.end;return!(t.equals(n)&&n.equals(e)&&e.equals(i))},length:function(t){for(var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=void 0===t.subdivisions?this.getSubdivisions({precision:n}):t.subdivisions,i=0,r=e.length,s=0;s<r;s++){i+=e[s].endpointDistance()}return i},lengthAtT:function(t,n){if(t<=0)return 0;var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision;return this.divide(t)[0].length({precision:e})},pointAt:function(t,n){if(t<=0)return this.start.clone();if(1<=t)return this.end.clone();var e=this.tAt(t,n);return this.pointAtT(e)},pointAtLength:function(t,n){var e=this.tAtLength(t,n);return this.pointAtT(e)},pointAtT:function(t){return t<=0?this.start.clone():1<=t?this.end.clone():this.getSkeletonPoints(t).divider},PRECISION:3,round:function(t){return this.start.round(t),this.controlPoint1.round(t),this.controlPoint2.round(t),this.end.round(t),this},scale:function(t,n,e){return this.start.scale(t,n,e),this.controlPoint1.scale(t,n,e),this.controlPoint2.scale(t,n,e),this.end.scale(t,n,e),this},tangentAt:function(t,n){if(!this.isDifferentiable())return null;t<0?t=0:1<t&&(t=1);var e=this.tAt(t,n);return this.tangentAtT(e)},tangentAtLength:function(t,n){if(!this.isDifferentiable())return null;var e=this.tAtLength(t,n);return this.tangentAtT(e)},tangentAtT:function(t){if(!this.isDifferentiable())return null;t<0?t=0:1<t&&(t=1);var n=this.getSkeletonPoints(t),e=n.startControlPoint2,i=n.dividerControlPoint1,r=n.divider,s=new N(e,i);return s.translate(r.x-e.x,r.y-e.y),s},tAt:function(t,n){if(t<=0)return 0;if(1<=t)return 1;var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions},r=this.length(i)*t;return this.tAtLength(r,i)},tAtLength:function(t,n){var e=!0;t<0&&(e=!1,t=-t);for(var i,r,s,o,a,h=void 0===(n=n||{}).precision?this.PRECISION:n.precision,u=void 0===n.subdivisions?this.getSubdivisions({precision:h}):n.subdivisions,c={precision:h,subdivisions:u},l=0,f=u.length,d=1/f,g=0;g<f;g++){var v=e?g:f-1-g,p=u[g],m=p.endpointDistance();if(t<=l+m){i=p,r=v*d,s=(v+1)*d,o=e?t-l:m+l-t,a=e?m+l-t:t-l;break}l+=m}if(!i)return e?1:0;for(var y=this.length(c),x=_(10,-h);;){var w,b;if((0!==y?o/y:0)<x)return r;if((0!==y?a/y:0)<x)return s;var S=i.divide(.5);d/=2;var P=S[0].endpointDistance(),A=S[1].endpointDistance();b=o<=P?(i=S[0],s-=d,P-(w=o)):(i=S[1],r+=d,A-(w=o-P)),o=w,a=b}},toPoints:function(t){for(var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=void 0===t.subdivisions?this.getSubdivisions({precision:n}):t.subdivisions,i=[e[0].start.clone()],r=e.length,s=0;s<r;s++){var o=e[s];i.push(o.end.clone())}return i},toPolyline:function(t){return new X(this.toPoints(t))},toString:function(){return this.start+" "+this.controlPoint1+" "+this.controlPoint2+" "+this.end},translate:function(t,n){return this.start.translate(t,n),this.controlPoint1.translate(t,n),this.controlPoint2.translate(t,n),this.end.translate(t,n),this}},tt.prototype.divide=tt.prototype.divideAtT;var et=function(t){if(!(this instanceof et))return new et(t);if("string"==typeof t)return new et.parse(t);var n,e;if(this.segments=[],t)if(Array.isArray(t)&&0!==t.length)if(e=(t=t.reduce(function(t,n){return t.concat(n)},[])).length,t[0].isSegment)for(n=0;n<e;n++){var i=t[n];this.appendSegment(i)}else{var r=null;for(n=0;n<e;n++){var s=t[n];if(!(s instanceof N||s instanceof tt))throw new Error("Cannot construct a path segment from the provided object.");0===n&&this.appendSegment(et.createSegment("M",s.start)),r&&!r.end.equals(s.start)&&this.appendSegment(et.createSegment("M",s.start)),s instanceof N?this.appendSegment(et.createSegment("L",s.end)):s instanceof tt&&this.appendSegment(et.createSegment("C",s.controlPoint1,s.controlPoint2,s.end)),r=s}}else if(t.isSegment)this.appendSegment(t);else if(t instanceof N)this.appendSegment(et.createSegment("M",t.start)),this.appendSegment(et.createSegment("L",t.end));else if(t instanceof tt)this.appendSegment(et.createSegment("M",t.start)),this.appendSegment(et.createSegment("C",t.controlPoint1,t.controlPoint2,t.end));else{if(!(t instanceof X))throw new Error("Cannot construct a path from the provided object.");if(!t.points||0===t.points.length)return;for(e=t.points.length,n=0;n<e;n++){var o=t.points[n];0===n?this.appendSegment(et.createSegment("M",o)):this.appendSegment(et.createSegment("L",o))}}else;};function it(t,n){return n.unshift(null),new(Function.prototype.bind.apply(t,n))}et.parse=function(t){if(!t)return new et;for(var n=new et,e=t.match(/(?:[a-zA-Z] *)(?:(?:-?\d+(?:\.\d+)?(?:e[-+]?\d+)? *,? *)|(?:-?\.\d+ *,? *))+|(?:[a-zA-Z] *)(?! |\d|-|\.)/g),i=e.length,r=0;r<i;r++){var s=e[r].match(/(?:[a-zA-Z])|(?:(?:-?\d+(?:\.\d+)?(?:e[-+]?\d+)?))|(?:(?:-?\.\d+))/g),o=et.createSegment.apply(this,s);n.appendSegment(o)}return n},et.createSegment=function(t){var n=arguments;if(!t)throw new Error("Type must be provided.");var e=et.segmentTypes[t];if(!e)throw new Error(t+" is not a recognized path segment type.");for(var i=[],r=arguments.length,s=1;s<r;s++)i.push(n[s]);return it(e,i)},et.prototype={type:v.Path,appendSegment:function(t){var n,e=this.segments,i=e.length,r=0!==i?e[i-1]:null;if(Array.isArray(t)){if(!(t=t.reduce(function(t,n){return t.concat(n)},[]))[0].isSegment)throw new Error("Segments required.");for(var s=t.length,o=0;o<s;o++){var a=t[o];n=this.prepareSegment(a,r,null),e.push(n),r=n}}else{if(!t||!t.isSegment)throw new Error("Segment required.");n=this.prepareSegment(t,r,null),e.push(n)}},bbox:function(){var t,n=this.segments,e=n.length;if(0===e)return null;for(var i=0;i<e;i++){var r=n[i];if(r.isVisible){var s=r.bbox();t=t?t.union(s):s}}if(t)return t;var o=n[e-1];return new B(o.end.x,o.end.y,0,0)},clone:function(){for(var t=this.segments,n=t.length,e=new et,i=0;i<n;i++){var r=t[i].clone();e.appendSegment(r)}return e},closestPoint:function(t,n){var e=this.closestPointT(t,n);return e?this.pointAtT(e):null},closestPointLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.closestPointT(t,i);return r?this.lengthAtT(r,i):0},closestPointNormalizedLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.closestPointLength(t,i);if(0===r)return 0;var s=this.length(i);return 0===s?0:r/s},closestPointT:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;for(var r,s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,a=1/0,h=0;h<i;h++){var u=e[h],c=o[h];if(u.isVisible){var l=u.closestPointT(t,{precision:s,subdivisions:c}),f=u.pointAtT(l),d=new N(f,t).squaredLength();d<a&&(r={segmentIndex:h,value:l},a=d)}}return r||{segmentIndex:i-1,value:1}},closestPointTangent:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;for(var r,s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,a=1/0,h=0;h<i;h++){var u=e[h],c=o[h];if(u.isDifferentiable()){var l=u.closestPointT(t,{precision:s,subdivisions:c}),f=u.pointAtT(l),d=new N(f,t).squaredLength();d<a&&(r=u.tangentAtT(l),a=d)}}return r||null},containsPoint:function(t,n){var e=this.toPolylines(n);if(!e)return!1;for(var i=e.length,r=0,s=0;s<i;s++){e[s].containsPoint(t)&&r++}return r%2==1},divideAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.divideAtLength(r,i)},divideAtLength:function(t,n){var e=this.segments.length;if(0===e)return null;var i=!0;t<0&&(i=!1,t=-t);var r,s,o,a,h,u,c,l=void 0===(n=n||{}).precision?this.PRECISION:n.precision,f=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:l}):n.segmentSubdivisions,d=0;for(r=0;r<e;r++){var g=i?r:e-1-r;s=this.getSegment(g);var v=f[g],p=s.length({precision:l,subdivisions:v});if(s.isDifferentiable()&&(h=s,u=g,t<=d+p)){a=g,o=s.divideAtLength((i?1:-1)*(t-d),{precision:l,subdivisions:v});break}d+=p}if(!h)return null;o||(a=u,c=i?1:0,o=h.divideAtT(c));var m=this.clone();m.replaceSegment(a,o);var y=a,x=a+1,w=a+2;o[0].isDifferentiable()||(m.removeSegment(y),x-=1,w-=1);var b=m.getSegment(x).start;m.insertSegment(x,et.createSegment("M",b)),w+=1,o[1].isDifferentiable()||(m.removeSegment(w-1),w-=1);var S=w-y-1;for(r=w;r<m.segments.length;r++){var P=this.getSegment(r-S);if("Z"===(s=m.getSegment(r)).type&&!P.subpathStartSegment.end.equals(s.subpathStartSegment.end)){var A=et.createSegment("L",P.end);m.replaceSegment(r,A)}}return[new et(m.segments.slice(0,x)),new et(m.segments.slice(x))]},equals:function(t){if(!t)return!1;var n=this.segments,e=t.segments,i=n.length;if(e.length!==i)return!1;for(var r=0;r<i;r++){var s=n[r],o=e[r];if(s.type!==o.type||!s.equals(o))return!1}return!0},getSegment:function(t){var n=this.segments,e=n.length;if(0===e)throw new Error("Path has no segments.");if(t<0&&(t=e+t),e<=t||t<0)throw new Error("Index out of range.");return n[t]},getSegmentSubdivisions:function(t){for(var n=this.segments,e=n.length,i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=[],s=0;s<e;s++){var o=n[s].getSubdivisions({precision:i});r.push(o)}return r},getSubpaths:function(){for(var t=this.clone().validate().segments,n=t.length,e=[],i=0;i<n;i++){var r=t[i];r.isSubpathStart?e.push(new et(r)):e[e.length-1].appendSegment(r)}return e},insertSegment:function(t,n){var e,i=this.segments,r=i.length;if(t<0&&(t=r+t+1),r<t||t<0)throw new Error("Index out of range.");var s=null,o=null;if(0!==r&&(o=1<=t?(s=i[t-1]).nextSegment:i[0]),Array.isArray(n)){if(!(n=n.reduce(function(t,n){return t.concat(n)},[]))[0].isSegment)throw new Error("Segments required.");for(var a=n.length,h=0;h<a;h++){var u=n[h];e=this.prepareSegment(u,s,o),i.splice(t+h,0,e),s=e}}else{if(!n||!n.isSegment)throw new Error("Segment required.");e=this.prepareSegment(n,s,o),i.splice(t,0,e)}},intersectionWithLine:function(t,n){var e=null,i=this.toPolylines(n);if(!i)return null;for(var r=0,s=i.length;r<s;r++){var o=i[r],a=t.intersect(o);a&&(e||(e=[]),Array.isArray(a)?Array.prototype.push.apply(e,a):e.push(a))}return e},isDifferentiable:function(){for(var t=this.segments,n=t.length,e=0;e<n;e++){if(t[e].isDifferentiable())return!0}return!1},isValid:function(){var t=this.segments;return 0===t.length||"M"===t[0].type},length:function(t){var n=this.segments,e=n.length;if(0===e)return 0;for(var i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=void 0===t.segmentSubdivisions?this.getSegmentSubdivisions({precision:i}):t.segmentSubdivisions,s=0,o=0;o<e;o++){var a=n[o],h=r[o];s+=a.length({subdivisions:h})}return s},lengthAtT:function(t,n){var e=this.segments,i=e.length;if(0===i)return 0;var r=t.segmentIndex;if(r<0)return 0;var s=t.value;i<=r?(r=i-1,s=1):s<0?s=0:1<s&&(s=1);for(var o,a=void 0===(n=n||{}).precision?this.PRECISION:n.precision,h=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:a}):n.segmentSubdivisions,u=0,c=0;c<r;c++){var l=e[c];o=h[c],u+=l.length({precisison:a,subdivisions:o})}return l=e[r],o=h[r],u+=l.lengthAtT(s,{precisison:a,subdivisions:o})},pointAt:function(t,n){if(0===this.segments.length)return null;if(t<=0)return this.start.clone();if(1<=t)return this.end.clone();var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.pointAtLength(r,i)},pointAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;if(0===t)return this.start.clone();var r=!0;t<0&&(r=!1,t=-t);for(var s,o=void 0===(n=n||{}).precision?this.PRECISION:n.precision,a=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:o}):n.segmentSubdivisions,h=0,u=0;u<i;u++){var c=r?u:i-1-u,l=e[c],f=a[c],d=l.length({precision:o,subdivisions:f});if(l.isVisible){if(t<=h+d)return l.pointAtLength((r?1:-1)*(t-h),{precision:o,subdivisions:f});s=l}h+=d}return s?r?s.end:s.start:e[i-1].end.clone()},pointAtT:function(t){var n=this.segments,e=n.length;if(0===e)return null;var i=t.segmentIndex;if(i<0)return n[0].pointAtT(0);if(e<=i)return n[e-1].pointAtT(1);var r=t.value;return r<0?r=0:1<r&&(r=1),n[i].pointAtT(r)},PRECISION:3,prepareSegment:function(t,n,e){t.previousSegment=n,t.nextSegment=e,n&&(n.nextSegment=t),e&&(e.previousSegment=t);var i=t;return t.isSubpathStart&&(t.subpathStartSegment=t,i=e),i&&this.updateSubpathStartSegment(i),t},removeSegment:function(t){var n=this.segments,e=n.length;if(0===e)throw new Error("Path has no segments.");if(t<0&&(t=e+t),e<=t||t<0)throw new Error("Index out of range.");var i=n.splice(t,1)[0],r=i.previousSegment,s=i.nextSegment;r&&(r.nextSegment=s),s&&(s.previousSegment=r),i.isSubpathStart&&s&&this.updateSubpathStartSegment(s)},replaceSegment:function(t,n){var e,i=this.segments,r=i.length;if(0===r)throw new Error("Path has no segments.");if(t<0&&(t=r+t),r<=t||t<0)throw new Error("Index out of range.");var s=i[t],o=s.previousSegment,a=s.nextSegment,h=s.isSubpathStart;if(Array.isArray(n)){if(!(n=n.reduce(function(t,n){return t.concat(n)},[]))[0].isSegment)throw new Error("Segments required.");i.splice(t,1);for(var u=n.length,c=0;c<u;c++){var l=n[c];e=this.prepareSegment(l,o,a),i.splice(t+c,0,e),o=e,h&&e.isSubpathStart&&(h=!1)}}else{if(!n||!n.isSegment)throw new Error("Segment required.");e=this.prepareSegment(n,o,a),i.splice(t,1,e),h&&e.isSubpathStart&&(h=!1)}h&&a&&this.updateSubpathStartSegment(a)},round:function(t){for(var n=this.segments,e=n.length,i=0;i<e;i++){n[i].round(t)}return this},scale:function(t,n,e){for(var i=this.segments,r=i.length,s=0;s<r;s++){i[s].scale(t,n,e)}return this},segmentAt:function(t,n){var e=this.segmentIndexAt(t,n);return e?this.getSegment(e):null},segmentAtLength:function(t,n){var e=this.segmentIndexAtLength(t,n);return e?this.getSegment(e):null},segmentIndexAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.segmentIndexAtLength(r,i)},segmentIndexAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;var r=!0;t<0&&(r=!1,t=-t);for(var s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,a=null,h=0,u=0;u<i;u++){var c=r?u:i-1-u,l=e[c],f=o[c],d=l.length({precision:s,subdivisions:f});if(l.isVisible){if(t<=h+d)return c;a=c}h+=d}return a},serialize:function(){if(!this.isValid())throw new Error("Invalid path segments.");return this.toString()},tangentAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.tangentAtLength(r,i)},tangentAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;var r=!0;t<0&&(r=!1,t=-t);for(var s,o=void 0===(n=n||{}).precision?this.PRECISION:n.precision,a=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:o}):n.segmentSubdivisions,h=0,u=0;u<i;u++){var c=r?u:i-1-u,l=e[c],f=a[c],d=l.length({precision:o,subdivisions:f});if(l.isDifferentiable()){if(t<=h+d)return l.tangentAtLength((r?1:-1)*(t-h),{precision:o,subdivisions:f});s=l}h+=d}if(s){var g=r?1:0;return s.tangentAtT(g)}return null},tangentAtT:function(t){var n=this.segments,e=n.length;if(0===e)return null;var i=t.segmentIndex;if(i<0)return n[0].tangentAtT(0);if(e<=i)return n[e-1].tangentAtT(1);var r=t.value;return r<0?r=0:1<r&&(r=1),n[i].tangentAtT(r)},toPoints:function(t){var n=this.segments,e=n.length;if(0===e)return null;for(var i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=void 0===t.segmentSubdivisions?this.getSegmentSubdivisions({precision:i}):t.segmentSubdivisions,s=[],o=[],a=0;a<e;a++){var h=n[a];if(h.isVisible){var u=r[a];if(0<u.length){var c=u.map(function(t){return t.start});Array.prototype.push.apply(o,c)}else o.push(h.start)}else 0<o.length&&(o.push(n[a-1].end),s.push(o),o=[])}return 0<o.length&&(o.push(this.end),s.push(o)),s},toPolylines:function(t){var n=[],e=this.toPoints(t);if(!e)return null;for(var i=0,r=e.length;i<r;i++)n.push(new X(e[i]));return n},toString:function(){for(var t=this.segments,n=t.length,e="",i=0;i<n;i++){e+=t[i].serialize()+" "}return e.trim()},translate:function(t,n){for(var e=this.segments,i=e.length,r=0;r<i;r++){e[r].translate(t,n)}return this},updateSubpathStartSegment:function(t){for(var n=t.previousSegment;t&&!t.isSubpathStart;)t.subpathStartSegment=n?n.subpathStartSegment:null,t=(n=t).nextSegment},validate:function(){return this.isValid()||this.insertSegment(0,et.createSegment("M",0,0)),this}},Object.defineProperty(et.prototype,"start",{configurable:!0,enumerable:!0,get:function(){var t=this.segments,n=t.length;if(0===n)return null;for(var e=0;e<n;e++){var i=t[e];if(i.isVisible)return i.start}return t[n-1].end}}),Object.defineProperty(et.prototype,"end",{configurable:!0,enumerable:!0,get:function(){var t=this.segments,n=t.length;if(0===n)return null;for(var e=n-1;0<=e;e--){var i=t[e];if(i.isVisible)return i.end}return t[n-1].end}});var rt={bbox:function(){throw new Error("Declaration missing for virtual function.")},clone:function(){throw new Error("Declaration missing for virtual function.")},closestPoint:function(){throw new Error("Declaration missing for virtual function.")},closestPointLength:function(){throw new Error("Declaration missing for virtual function.")},closestPointNormalizedLength:function(){throw new Error("Declaration missing for virtual function.")},closestPointT:function(t){if(this.closestPointNormalizedLength)return this.closestPointNormalizedLength(t);throw new Error("Neither closestPointT() nor closestPointNormalizedLength() function is implemented.")},closestPointTangent:function(){throw new Error("Declaration missing for virtual function.")},divideAt:function(){throw new Error("Declaration missing for virtual function.")},divideAtLength:function(){throw new Error("Declaration missing for virtual function.")},divideAtT:function(t){if(this.divideAt)return this.divideAt(t);throw new Error("Neither divideAtT() nor divideAt() function is implemented.")},equals:function(){throw new Error("Declaration missing for virtual function.")},getSubdivisions:function(){throw new Error("Declaration missing for virtual function.")},isDifferentiable:function(){throw new Error("Declaration missing for virtual function.")},isSegment:!0,isSubpathStart:!1,isVisible:!0,length:function(){throw new Error("Declaration missing for virtual function.")},lengthAtT:function(t){if(t<=0)return 0;var n=this.length();return 1<=t?n:n*t},nextSegment:null,pointAt:function(){throw new Error("Declaration missing for virtual function.")},pointAtLength:function(){throw new Error("Declaration missing for virtual function.")},pointAtT:function(t){if(this.pointAt)return this.pointAt(t);throw new Error("Neither pointAtT() nor pointAt() function is implemented.")},previousSegment:null,round:function(){throw new Error("Declaration missing for virtual function.")},subpathStartSegment:null,scale:function(){throw new Error("Declaration missing for virtual function.")},serialize:function(){throw new Error("Declaration missing for virtual function.")},tangentAt:function(){throw new Error("Declaration missing for virtual function.")},tangentAtLength:function(){throw new Error("Declaration missing for virtual function.")},tangentAtT:function(t){if(this.tangentAt)return this.tangentAt(t);throw new Error("Neither tangentAtT() nor tangentAt() function is implemented.")},toString:function(){throw new Error("Declaration missing for virtual function.")},translate:function(){throw new Error("Declaration missing for virtual function.")}};Object.defineProperty(rt,"end",{configurable:!0,enumerable:!0,writable:!0}),Object.defineProperty(rt,"start",{configurable:!0,enumerable:!0,get:function(){if(!this.previousSegment)throw new Error("Missing previous segment. (This segment cannot be the first segment of a path; OR segment has not yet been added to a path.)");return this.previousSegment.end}}),Object.defineProperty(rt,"type",{configurable:!0,enumerable:!0,get:function(){throw new Error("Bad segment declaration. No type specified.")}});var st=function(){for(var t,n,e=arguments,i=[],r=arguments.length,s=0;s<r;s++)i.push(e[s]);if(!(this instanceof st))return it(st,i);if(0===r)throw new Error("Lineto constructor expects a line, 1 point, or 2 coordinates (none provided).");if(i[0]instanceof N){if(1===r)return this.end=i[0].end.clone(),this;throw new Error("Lineto constructor expects a line, 1 point, or 2 coordinates ("+r+" lines provided).")}if("string"==typeof i[0]||"number"==typeof i[0]){if(2===r)return this.end=new L(+i[0],+i[1]),this;if(r<2)throw new Error("Lineto constructor expects a line, 1 point, or 2 coordinates ("+r+" coordinates provided).");var o;for(t=[],s=0;s<r;s+=2)o=i.slice(s,s+2),t.push(it(st,o));return t}if(1===r)return this.end=new L(i[0]),this;for(t=[],s=0;s<r;s+=1)n=i[s],t.push(new st(n));return t},ot={clone:function(){return new st(this.end)},divideAt:function(t){var n=new N(this.start,this.end).divideAt(t);return[new st(n[0]),new st(n[1])]},divideAtLength:function(t){var n=new N(this.start,this.end).divideAtLength(t);return[new st(n[0]),new st(n[1])]},getSubdivisions:function(){return[]},isDifferentiable:function(){return!!this.previousSegment&&!this.start.equals(this.end)},round:function(t){return this.end.round(t),this},scale:function(t,n,e){return this.end.scale(t,n,e),this},serialize:function(){var t=this.end;return this.type+" "+t.x+" "+t.y},toString:function(){return this.type+" "+this.start+" "+this.end},translate:function(t,n){return this.end.translate(t,n),this}};Object.defineProperty(ot,"type",{configurable:!0,enumerable:!0,value:"L"}),st.prototype=nt(rt,N.prototype,ot);var at=function(){for(var t,n,e=arguments,i=[],r=arguments.length,s=0;s<r;s++)i.push(e[s]);if(!(this instanceof at))return it(at,i);if(0===r)throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates (none provided).");if(i[0]instanceof tt){if(1===r)return this.controlPoint1=i[0].controlPoint1.clone(),this.controlPoint2=i[0].controlPoint2.clone(),this.end=i[0].end.clone(),this;throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates ("+r+" curves provided).")}if("string"==typeof i[0]||"number"==typeof i[0]){if(6===r)return this.controlPoint1=new L(+i[0],+i[1]),this.controlPoint2=new L(+i[2],+i[3]),this.end=new L(+i[4],+i[5]),this;if(r<6)throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates ("+r+" coordinates provided).");var o;for(t=[],s=0;s<r;s+=6)o=i.slice(s,s+6),t.push(it(at,o));return t}if(3===r)return this.controlPoint1=new L(i[0]),this.controlPoint2=new L(i[1]),this.end=new L(i[2]),this;if(r<3)throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates ("+r+" points provided).");for(t=[],s=0;s<r;s+=3)n=i.slice(s,s+3),t.push(it(at,n));return t},ht={clone:function(){return new at(this.controlPoint1,this.controlPoint2,this.end)},divideAt:function(t,n){var e=new tt(this.start,this.controlPoint1,this.controlPoint2,this.end).divideAt(t,n);return[new at(e[0]),new at(e[1])]},divideAtLength:function(t,n){var e=new tt(this.start,this.controlPoint1,this.controlPoint2,this.end).divideAtLength(t,n);return[new at(e[0]),new at(e[1])]},divideAtT:function(t){var n=new tt(this.start,this.controlPoint1,this.controlPoint2,this.end).divideAtT(t);return[new at(n[0]),new at(n[1])]},isDifferentiable:function(){if(!this.previousSegment)return!1;var t=this.start,n=this.controlPoint1,e=this.controlPoint2,i=this.end;return!(t.equals(n)&&n.equals(e)&&e.equals(i))},round:function(t){return this.controlPoint1.round(t),this.controlPoint2.round(t),this.end.round(t),this},scale:function(t,n,e){return this.controlPoint1.scale(t,n,e),this.controlPoint2.scale(t,n,e),this.end.scale(t,n,e),this},serialize:function(){var t=this.controlPoint1,n=this.controlPoint2,e=this.end;return this.type+" "+t.x+" "+t.y+" "+n.x+" "+n.y+" "+e.x+" "+e.y},toString:function(){return this.type+" "+this.start+" "+this.controlPoint1+" "+this.controlPoint2+" "+this.end},translate:function(t,n){return this.controlPoint1.translate(t,n),this.controlPoint2.translate(t,n),this.end.translate(t,n),this}};Object.defineProperty(ht,"type",{configurable:!0,enumerable:!0,value:"C"}),at.prototype=nt(rt,tt.prototype,ht);var ut=function(){for(var t,n,e=arguments,i=[],r=arguments.length,s=0;s<r;s++)i.push(e[s]);if(!(this instanceof ut))return it(ut,i);if(0===r)throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates (none provided).");if(i[0]instanceof N){if(1===r)return this.end=i[0].end.clone(),this;throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates ("+r+" lines provided).")}if(i[0]instanceof tt){if(1===r)return this.end=i[0].end.clone(),this;throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates ("+r+" curves provided).")}if("string"==typeof i[0]||"number"==typeof i[0]){if(2===r)return this.end=new L(+i[0],+i[1]),this;if(r<2)throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates ("+r+" coordinates provided).");var o;for(t=[],s=0;s<r;s+=2)o=i.slice(s,s+2),0===s?t.push(it(ut,o)):t.push(it(st,o));return t}if(1===r)return this.end=new L(i[0]),this;for(t=[],s=0;s<r;s+=1)n=i[s],0===s?t.push(new ut(n)):t.push(new st(n));return t},ct={bbox:function(){return null},clone:function(){return new ut(this.end)},closestPoint:function(){return this.end.clone()},closestPointNormalizedLength:function(){return 0},closestPointLength:function(){return 0},closestPointT:function(){return 1},closestPointTangent:function(){return null},divideAt:function(){return[this.clone(),this.clone()]},divideAtLength:function(){return[this.clone(),this.clone()]},equals:function(t){return this.end.equals(t.end)},getSubdivisions:function(){return[]},isDifferentiable:function(){return!1},isSubpathStart:!0,isVisible:!1,length:function(){return 0},lengthAtT:function(){return 0},pointAt:function(){return this.end.clone()},pointAtLength:function(){return this.end.clone()},pointAtT:function(){return this.end.clone()},round:function(t){return this.end.round(t),this},scale:function(t,n,e){return this.end.scale(t,n,e),this},serialize:function(){var t=this.end;return this.type+" "+t.x+" "+t.y},tangentAt:function(){return null},tangentAtLength:function(){return null},tangentAtT:function(){return null},toString:function(){return this.type+" "+this.end},translate:function(t,n){return this.end.translate(t,n),this}};Object.defineProperty(ct,"start",{configurable:!0,enumerable:!0,get:function(){throw new Error("Illegal access. Moveto segments should not need a start property.")}}),Object.defineProperty(ct,"type",{configurable:!0,enumerable:!0,value:"M"}),ut.prototype=nt(rt,ct);var lt=function(){for(var t=arguments,n=[],e=arguments.length,i=0;i<e;i++)n.push(t[i]);if(!(this instanceof lt))return it(lt,n);if(0<e)throw new Error("Closepath constructor expects no arguments.");return this},ft={clone:function(){return new lt},divideAt:function(t){var n=new N(this.start,this.end).divideAt(t);return[n[1].isDifferentiable()?new st(n[0]):this.clone(),new st(n[1])]},divideAtLength:function(t){var n=new N(this.start,this.end).divideAtLength(t);return[n[1].isDifferentiable()?new st(n[0]):this.clone(),new st(n[1])]},getSubdivisions:function(){return[]},isDifferentiable:function(){return!(!this.previousSegment||!this.subpathStartSegment)&&!this.start.equals(this.end)},round:function(){return this},scale:function(){return this},serialize:function(){return this.type},toString:function(){return this.type+" "+this.start+" "+this.end},translate:function(){return this}};Object.defineProperty(ft,"end",{configurable:!0,enumerable:!0,get:function(){if(!this.subpathStartSegment)throw new Error("Missing subpath start segment. (This segment needs a subpath start segment (e.g. Moveto); OR segment has not yet been added to a path.)");return this.subpathStartSegment.end}}),Object.defineProperty(ft,"type",{configurable:!0,enumerable:!0,value:"Z"}),lt.prototype=nt(rt,N.prototype,ft);var dt=et.segmentTypes={L:st,C:at,M:ut,Z:lt,z:lt};et.regexSupportedData=new RegExp("^[\\s\\d"+Object.keys(dt).join("")+",.]*$"),et.isDataSupported=function(t){return"string"==typeof t&&this.regexSupportedData.test(t)};var gt={curveThroughPoints:function(t){return console.warn("deprecated"),new et(tt.throughPoints(t)).serialize()},getCurveControlPoints:function(t){console.warn("deprecated");var n,e=[],i=[],r=t.length-1;if(1==r)return e[0]=new L((2*t[0].x+t[1].x)/3,(2*t[0].y+t[1].y)/3),i[0]=new L(2*e[0].x-t[0].x,2*e[0].y-t[0].y),[e,i];var s=[];for(n=1;n<r-1;n++)s[n]=4*t[n].x+2*t[n+1].x;s[0]=t[0].x+2*t[1].x,s[r-1]=(8*t[r-1].x+t[r].x)/2;var o=this.getFirstControlPoints(s);for(n=1;n<r-1;++n)s[n]=4*t[n].y+2*t[n+1].y;s[0]=t[0].y+2*t[1].y,s[r-1]=(8*t[r-1].y+t[r].y)/2;var a=this.getFirstControlPoints(s);for(n=0;n<r;n++)e.push(new L(o[n],a[n])),n<r-1?i.push(new L(2*t[n+1].x-o[n+1],2*t[n+1].y-a[n+1])):i.push(new L((t[r].x+o[r-1])/2,(t[r].y+a[r-1])/2));return[e,i]},getCurveDivider:function(t,n,e,i){console.warn("deprecated");var r=new tt(t,n,e,i);return function(t){var n=r.divide(t);return[{p0:n[0].start,p1:n[0].controlPoint1,p2:n[0].controlPoint2,p3:n[0].end},{p0:n[1].start,p1:n[1].controlPoint1,p2:n[1].controlPoint2,p3:n[1].end}]}},getFirstControlPoints:function(t){console.warn("deprecated");var n=t.length,e=[],i=[],r=2;e[0]=t[0]/r;for(var s=1;s<n;s++)i[s]=1/r,r=(s<n-1?4:3.5)-i[s],e[s]=(t[s]-e[s-1])/r;for(s=1;s<n;s++)e[n-s-1]-=i[n-s]*e[n-s];return e},getInversionSolver:function(t,n,e,i){console.warn("deprecated");var r=new tt(t,n,e,i);return function(t){return r.closestPointT(t)}}},vt=function(t){return this instanceof vt?"string"==typeof t?new vt.parse(t):void(this.points=Array.isArray(t)?t.map(L):[]):new vt(t)};function pt(t,n){var e=t.start.x,i=t.start.y,r=t.end.x,s=t.end.y,o=n.start.x,a=n.start.y,h=r-e,u=s-i,c=n.end.x-o,l=n.end.y-a,f=e-o,d=i-a,g=h*l-c*u,v=(h*d-u*f)/g,p=(c*d-l*f)/g;return 0<=v&&v<=1&&0<=p&&p<=1}function mt(t,n){var e=t.a,i=t.b,r=t.x,s=t.y,o=n.start.x-r,a=n.end.x-r,h=n.start.y-s,u=e*e,c=i*i,l=a-o,f=n.end.y-s-h,d=l*l/u+f*f/c,g=2*o*l/u+2*h*f/c,v=g*g-4*d*(o*o/u+h*h/c-1);if(0===v){var p=-g/2/d;return 0<=p&&p<=1}if(0<v){var m=Math.sqrt(v),y=(-g+m)/2/d,x=(-g-m)/2/d;return 0<=y&&y<=1||0<=x&&x<=1}return!1}function yt(t,n){return function(t,n,e,i){var r=Math.cos,s=Math.sin,o=s(n),a=r(n),h=s(i),u=r(i),c=o*o,l=a*a,f=o*a,d=h*h,g=u*u,v=h*u,p=t.a*t.a,m=t.b*t.b,y=e.a*e.a,x=e.b*e.b,w=p*c+m*l,b=y*d+x*g,S=p*l+m*c,P=y*g+x*d,A=2*(m-p)*f,T=2*(x-y)*v,L=-2*w*t.x-A*t.y,E=-2*b*e.x-T*e.y,C=-A*t.x-2*S*t.y,N=-T*e.x-2*P*e.y,I=w*t.x*t.x+S*t.y*t.y+A*t.x*t.y-p*m,M=b*e.x*e.x+P*e.y*e.y+T*e.x*e.y-y*x;T/=2,E/=2,N/=2;var R=Ht([[w,A/=2,L/=2],[A,S,C/=2],[L,C,I]]),O=Ht([[b,T,E],[T,P,N],[E,N,M]]),D=.33333333*(Ht([[b,A,L],[T,S,C],[E,C,I]])+Ht([[w,T,L],[A,P,C],[L,N,I]])+Ht([[w,A,E],[A,S,N],[L,C,M]])),F=.33333333*(Ht([[w,T,E],[A,P,N],[L,N,M]])+Ht([[b,A,E],[T,S,N],[E,C,M]])+Ht([[b,T,L],[T,P,C],[E,N,I]])),q=Bt([[R,D],[D,F]]),V=Bt([[R,F],[D,O]]),z=Bt([[D,F],[F,O]]);if(0<Bt([[2*q,V],[V,2*z]])&&(0<F||0<D))return!1;return!0}(t,0,n,0)}function xt(t,n){var e=n.start,i=n.end,r=t.x,s=t.y,o=t.width,a=t.height;return!(e.x>r+o&&i.x>r+o||e.x<r&&i.x<r||e.y>s+a&&i.y>s+a||e.y<s&&i.y<s)&&(!(!t.containsPoint(n.start)&&!t.containsPoint(n.end))||(pt(t.topLine(),n)||pt(t.rightLine(),n)||pt(t.bottomLine(),n)||pt(t.leftLine(),n)))}function wt(t,n){return!!bt(t,B.fromEllipse(n))&&Et(vt.fromRect(t),n)}function bt(t,n){return t.x<n.x+n.width&&t.x+t.width>n.x&&t.y<n.y+n.height&&t.y+t.height>n.y}function St(t,n){return Vt(t,n,{interior:!1})}function Pt(t,n){return zt(t,n,{interior:!1})}function At(t,n){return kt(t,n,{interior:!1})}function Tt(t,n){return Gt(t,n,{interior:!1})}function Lt(t,n){return Vt(t,n,{interior:!0})}function Et(t,n){return zt(t,n,{interior:!0})}function Ct(t,n){return kt(t,n,{interior:!0})}function Nt(t,n){return Gt(t,n,{interior:!0})}function It(t,n){return Wt(t,n,{interior:!0})}function Mt(t,e,i){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?Lt(n,e):St(n,e)})}function Rt(t,e,i){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?Et(n,e):Pt(n,e)})}function Ot(t,n,e){return Ft(t,vt.fromRect(n),e)}function Dt(t,n,e){return jt(t,n,e,{interior:!1})}function Ft(t,n,e){return jt(t,n,e,{interior:!0})}function qt(t,e,i,r){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?Ft(e,n,r):Dt(e,n,r)})}function Vt(t,n,e){void 0===e&&(e={});var i,r=e.interior;if(void 0===r&&(r=!1),r){if(t.containsPoint(n.start))return!0;var s=t.start,o=t.end,a=t.points;i=o.equals(s)?a:a.concat([s])}else i=t.points;for(var h=i.length,u=new N,c=0;c<h-1;c++)if(u.start=i[c],u.end=i[c+1],pt(n,u))return!0;return!1}function zt(t,n,e){void 0===e&&(e={});var i,r=t.start,s=t.end,o=t.points;if(n.containsPoint(r))return!0;var a=e.interior;if(void 0===a&&(a=!1),a){if(t.containsPoint(n.center()))return!0;i=s.equals(r)?o:o.concat([r])}else i=o;for(var h=i.length,u=new N,c=0;c<h-1;c++)if(u.start=i[c],u.end=i[c+1],mt(n,u))return!0;return!1}function kt(t,n,e){return Wt(t,vt.fromRect(n),e)}function jt(t,e,i,r){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?Wt(e,n,r):Gt(e,n,r)})}function Gt(t,n,e){void 0===e&&(e={});var i,r=e.interior;if(void 0===r&&(r=!1),r){var s=n.start;if(t.containsPoint(s))return!0;i=t.clone().close()}else i=t;for(var o=n.points,a=o.length,h=new N,u=0;u<a-1;u++)if(h.start=o[u],h.end=o[u+1],St(i,h))return!0;return!1}function Wt(t,n,e){return n.containsPoint(t.start)||Gt(t,n.clone().close(),e)}function Bt(t){return t[0][0]*t[1][1]-t[0][1]*t[1][0]}function Ht(t){return t[0][0]*t[1][1]*t[2][2]-t[0][0]*t[1][2]*t[2][1]-t[0][1]*t[1][0]*t[2][2]+t[0][1]*t[1][2]*t[2][0]+t[0][2]*t[1][0]*t[2][1]-t[0][2]*t[1][1]*t[2][0]}vt.parse=function(t){return new vt(U(t))},vt.fromRect=function(t){return new vt([t.topLeft(),t.topRight(),t.bottomRight(),t.bottomLeft()])},vt.prototype=nt(X.prototype,{type:v.Polygon,clone:function(){return new vt(Z(this.points))},convexHull:function(){return new vt(Y(this.points))},lengthPoints:function(){var t=this.start,n=this.end,e=this.points;return e.length<=1||t.equals(n)?e:e.concat([t.clone()])}});var Ut={intersection:{exists:function t(n,e,i,r){switch(n.type){case v.Line:switch(e.type){case v.Line:return pt(n,e)}break;case v.Ellipse:switch(e.type){case v.Line:return mt(n,e);case v.Ellipse:return yt(n,e)}break;case v.Rect:switch(e.type){case v.Line:return xt(n,e);case v.Ellipse:return wt(n,e);case v.Rect:return bt(n,e)}break;case v.Polyline:switch(e.type){case v.Line:return St(n,e);case v.Ellipse:return Pt(n,e);case v.Rect:return At(n,e);case v.Polyline:return Tt(n,e)}break;case v.Polygon:switch(e.type){case v.Line:return Lt(n,e);case v.Ellipse:return Et(n,e);case v.Rect:return Ct(n,e);case v.Polyline:return Nt(n,e);case v.Polygon:return It(n,e)}break;case v.Path:switch(e.type){case v.Line:return Mt(n,e,i);case v.Ellipse:return Rt(n,e,i);case v.Rect:return Ot(n,e,i);case v.Polyline:return Dt(n,e,i);case v.Polygon:return Ft(n,e,i);case v.Path:return qt(n,e,i,r)}}switch(e.type){case v.Ellipse:case v.Rect:case v.Polyline:case v.Polygon:case v.Path:return t(e,n,r,i);default:throw Error("The intersection for "+n+" and "+e+" could not be found.")}},lineWithLine:pt,ellipseWithLine:mt,ellipseWithEllipse:yt,rectWithLine:xt,rectWithEllipse:wt,rectWithRect:bt,polylineWithLine:St,polylineWithEllipse:Pt,polylineWithRect:At,polylineWithPolyline:Tt,polygonWithLine:Lt,polygonWithEllipse:Et,polygonWithRect:Ct,polygonWithPolyline:Nt,polygonWithPolygon:It,pathWithLine:Mt,pathWithEllipse:Rt,pathWithRect:Ot,pathWithPolyline:Dt,pathWithPolygon:Ft,pathWithPath:qt},scale:{linear:function(t,n,e){var i=t[1]-t[0],r=n[1]-n[0];return(e-t[0])/i*r+n[0]||0}},normalizeAngle:a,snapToGrid:s,toDeg:c,toRad:l,random:o,bezier:gt,Curve:tt,Ellipse:D,ellipse:F,Line:N,line:I,Path:et,Point:L,point:t,Polyline:X,Polygon:vt,Rect:B,rect:H,types:v};return function(){if(!("object"==typeof window&&!!window.SVGAngle))return function(){throw new Error("SVG is required to use Vectorizer.")};var F={svg:"http://www.w3.org/2000/svg",xmlns:"http://www.w3.org/2000/xmlns/",xml:"http://www.w3.org/XML/1998/namespace",xlink:"http://www.w3.org/1999/xlink",xhtml:"http://www.w3.org/1999/xhtml"},t=Math,v=t.PI,s=t.atan2,o=t.sqrt,l=t.min,f=t.max,p=t.cos,m=t.sin,q=function(t,n,e){if(!(this instanceof q))return q.apply(Object.create(q.prototype),arguments);if(t){if(q.isV(t)&&(t=t.node),n=n||{},q.isString(t)){if("svg"===(t=t.trim()).toLowerCase())t=q.createSvgDocument();else if("<"===t[0]){var i=q.createSvgDocument(t);if(1<i.childNodes.length){var r,s,o=[];for(r=0,s=i.childNodes.length;r<s;r++){var a=i.childNodes[r];o.push(new q(document.importNode(a,!0)))}return o}t=document.importNode(i.firstChild,!0)}else t=document.createElementNS(F.svg,t);q.ensureId(t)}return this.node=t,this.setAttributes(n),e&&this.append(e),this}},n=q.prototype;function V(t,n,e){e||(e={});for(var i=e.includeAnnotationIndices,r=e.eol,s=e.lineHeight,o=e.baseSize,a=0,h={},u=n.length-1,c=0;c<=u;c++){var l=n[c],f=null;if(q.isObject(l)){var d=l.attrs,g=q("tspan",d),v=g.node,p=l.t;r&&c===u&&(p+=r),v.textContent=p;var m=d.class;m&&g.addClass(m),i&&g.attr("annotations",l.annotations),f=parseFloat(d["font-size"]),isFinite(f)||(f=o),f&&a<f&&(a=f)}else r&&c===u&&(l+=r),v=document.createTextNode(l||" "),o&&a<o&&(a=o);t.appendChild(v)}return a&&(h.maxFontSize=a),s?h.lineHeight=s:a&&(h.lineHeight=1.2*a),h}Object.defineProperty(n,"id",{enumerable:!0,get:function(){return this.node.id},set:function(t){this.node.id=t}}),n.getTransformToElement=function(t){var n=this.node;if(q.isSVGGraphicsElement(t)&&q.isSVGGraphicsElement(n)){var e=q.toNode(t).getScreenCTM(),i=n.getScreenCTM();if(e&&i)return e.inverse().multiply(i)}return q.createSVGMatrix()},n.transform=function(t,n){var e=this.node;if(q.isUndefined(t))return q.transformStringToMatrix(this.attr("transform"));if(n&&n.absolute)return this.attr("transform",q.matrixToTransformString(t));var i=q.createSVGTransform(t);return e.transform.baseVal.appendItem(i),this},n.translate=function(t,n,e){e=e||{},n=n||0;var i=this.attr("transform")||"",r=q.parseTransformString(i);if(i=r.value,q.isUndefined(t))return r.translate;i=i.replace(/translate\([^)]*\)/g,"").trim();var s="translate("+(e.absolute?t:r.translate.tx+t)+","+(e.absolute?n:r.translate.ty+n)+")";return this.attr("transform",(s+" "+i).trim()),this},n.rotate=function(t,n,e,i){i=i||{};var r=this.attr("transform")||"",s=q.parseTransformString(r);if(r=s.value,q.isUndefined(t))return s.rotate;r=r.replace(/rotate\([^)]*\)/g,"").trim(),t%=360;var o="rotate("+(i.absolute?t:s.rotate.angle+t)+(void 0!==n&&void 0!==e?","+n+","+e:"")+")";return this.attr("transform",(r+" "+o).trim()),this},n.scale=function(t,n){n=q.isUndefined(n)?t:n;var e=this.attr("transform")||"",i=q.parseTransformString(e);if(e=i.value,q.isUndefined(t))return i.scale;e=e.replace(/scale\([^)]*\)/g,"").trim();var r="scale("+t+","+n+")";return this.attr("transform",(e+" "+r).trim()),this},n.bbox=function(t,n){var e,i=this.node,r=i.ownerSVGElement;if(!r)return new B(0,0,0,0);try{e=i.getBBox()}catch(t){e={x:i.clientLeft,y:i.clientTop,width:i.clientWidth,height:i.clientHeight}}if(t)return new B(e);var s=this.getTransformToElement(n||r);return q.transformRect(e,s)},n.getBBox=function(t){var n,e={},i=this.node;if(!i.ownerSVGElement||!q.isSVGGraphicsElement(i))return new B(0,0,0,0);if(t&&(t.target&&(e.target=q.toNode(t.target)),t.recursive&&(e.recursive=t.recursive)),e.recursive){var r=this.children(),s=r.length;if(0===s)return this.getBBox({target:e.target,recursive:!1});e.target||(e.target=this);for(var o=0;o<s;o++){var a,h=r[o];a=0===h.children().length?h.getBBox({target:e.target,recursive:!1}):h.getBBox({target:e.target,recursive:!0}),n=n?n.union(a):a}return n}try{n=i.getBBox()}catch(t){n={x:i.clientLeft,y:i.clientTop,width:i.clientWidth,height:i.clientHeight}}if(e.target){var u=this.getTransformToElement(e.target);return q.transformRect(n,u)}return new B(n)};var z=/em$/;function k(t,n){var e=parseFloat(t);return z.test(t)?e*n:e}n.text=function(t,n){if(t&&"string"!=typeof t)throw new Error("Vectorizer: text() expects the first argument to be a string.");t=q.sanitizeText(t),n||(n={});var e=n.displayEmpty,i=n.eol,r=n.textPath,s=n.textVerticalAnchor,o="middle"===s||"bottom"===s||"top"===s,a=n.x;void 0===a&&(a=this.attr("x")||0);var h=n.includeAnnotationIndices,u=n.annotations;u&&!q.isArray(u)&&(u=[u]);var c=n.lineHeight,l="auto"===c,f=l?"1.5em":c||"1em";this.empty(),this.attr({"xml:space":"preserve",display:t||e?null:"none"});var d=parseFloat(this.attr("font-size"));d||(d=16,(o||u)&&this.attr("font-size",d));var g,v=document;g=r?("string"==typeof r&&(r={d:r}),function(t,n){t||(t={});var e=q("textPath"),i=t.d;if(i&&void 0===t["xlink:href"]){var r=q("path").attr("d",i).appendTo(n.defs());e.attr("xlink:href","#"+r.id)}return q.isObject(t)&&e.attr(t),e.node}(r,this)):v.createDocumentFragment();for(var p,m=0,y=t.split("\n"),x=[],w=0,b=y.length-1;w<=b;w++){var S,P=f,A="v-line",T=v.createElementNS(F.svg,"tspan"),L=y[w];if(L)if(u){var E=q.annotateString(L,u,{offset:-m,includeAnnotationIndices:h}),C=(S=V(T,E,{includeAnnotationIndices:h,eol:w!==b&&i,lineHeight:l?null:f,baseSize:d})).lineHeight;C&&l&&0!==w&&(P=C),0===w&&(p=.8*S.maxFontSize)}else i&&w!==b&&(L+=i),T.textContent=L;else{T.textContent="-",A+=" v-empty-line";var N=T.style;if(N.fillOpacity=0,N.strokeOpacity=0,u){S={};for(var I=d,M=(E=q.findAnnotationsAtIndex(u,m)).length;0<M;M--){var R=E[M-1].attrs;if(R&&"font-size"in R){var O=parseFloat(R["font-size"]);if(isFinite(O)){I=O;break}}}l&&(0<w?P=1.2*I:p=.8*I),T.setAttribute("font-size",I),S.maxFontSize=I}}S&&x.push(S),0<w&&T.setAttribute("dy",P),(0<w||r)&&T.setAttribute("x",a),T.className.baseVal=A,g.appendChild(T),m+=L.length+1}if(o)if(u)P=function(t,n,e,i){if(!Array.isArray(n))return 0;var r=n.length;if(!r)return 0;for(var s=n[0],o=k(s.maxFontSize,e)||e,a=0,h=k(i,e),u=1;u<r;u++)a+=k((s=n[u]).lineHeight,e)||h;var c,l=k(s.maxFontSize,e)||e;switch(t){case"middle":c=o/2-.15*l-a/2;break;case"bottom":c=-.25*l-a;break;default:case"top":c=.8*o}return c}(s,x,d,f);else if("top"===s)P="0.8em";else{var D;switch(0<b?(D=parseFloat(f)||1,D*=b,z.test(f)||(D/=d)):D=0,s){case"middle":P=.3-D/2+"em";break;case"bottom":P=-D-.3+"em"}}else 0===s?P="0em":s?P=s:(P=0,null===this.attr("y")&&this.attr("y",p||"0.8em"));return g.firstChild.setAttribute("dy",P),this.append(g),this},n.removeAttr=function(t){var n=q.qualifyAttr(t),e=this.node;return n.ns?e.hasAttributeNS(n.ns,n.local)&&e.removeAttributeNS(n.ns,n.local):e.hasAttribute(t)&&e.removeAttribute(t),this},n.attr=function(t,n){if(q.isUndefined(t)){for(var e=this.node.attributes,i={},r=0;r<e.length;r++)i[e[r].name]=e[r].value;return i}if(q.isString(t)&&q.isUndefined(n))return this.node.getAttribute(t);if("object"==typeof t)for(var s in t)t.hasOwnProperty(s)&&this.setAttribute(s,t[s]);else this.setAttribute(t,n);return this},n.normalizePath=function(){return"PATH"===this.tagName()&&this.attr("d",q.normalizePathData(this.attr("d"))),this},n.remove=function(){return this.node.parentNode&&this.node.parentNode.removeChild(this.node),this},n.empty=function(){for(;this.node.firstChild;)this.node.removeChild(this.node.firstChild);return this},n.setAttributes=function(t){for(var n in t)t.hasOwnProperty(n)&&this.setAttribute(n,t[n]);return this},n.append=function(t){q.isArray(t)||(t=[t]);for(var n=0,e=t.length;n<e;n++)this.node.appendChild(q.toNode(t[n]));return this},n.prepend=function(t){var n=this.node.firstChild;return n?q(n).before(t):this.append(t)},n.before=function(t){var n=this.node,e=n.parentNode;if(e){q.isArray(t)||(t=[t]);for(var i=0,r=t.length;i<r;i++)e.insertBefore(q.toNode(t[i]),n)}return this},n.appendTo=function(t){return q.toNode(t).appendChild(this.node),this},n.svg=function(){return this.node instanceof window.SVGSVGElement?this:q(this.node.ownerSVGElement)},n.tagName=function(){return this.node.tagName.toUpperCase()},n.defs=function(){var t=this.svg()||this,n=t.node.getElementsByTagName("defs")[0];return n?q(n):q("defs").appendTo(t)},n.clone=function(){var t=q(this.node.cloneNode(!0));return t.node.id=q.uniqueId(),t},n.findOne=function(t){var n=this.node.querySelector(t);return n?q(n):void 0},n.find=function(t){var n=[],e=this.node.querySelectorAll(t);if(e)for(var i=0;i<e.length;i++)n.push(q(e[i]));return n},n.children=function(){for(var t=this.node.childNodes,n=[],e=0;e<t.length;e++){1===t[e].nodeType&&n.push(q(t[e]))}return n},n.parent=function(){return q(this.node.parentNode)||null},n.index=function(){for(var t=0,n=this.node.previousSibling;n;)1===n.nodeType&&t++,n=n.previousSibling;return t},n.findParentByClass=function(t,n){for(var e=this.node.ownerSVGElement,i=this.node.parentNode;i&&i!==n&&i!==e;){var r=q(i);if(r.hasClass(t))return r;i=i.parentNode}return null},n.contains=function(t){var n=this.node,e=q.toNode(t),i=e&&e.parentNode;return n===i||!!(i&&1===i.nodeType&&16&n.compareDocumentPosition(i))},n.toLocalPoint=function(t,n){var e=this.svg().node,i=e.createSVGPoint();i.x=t,i.y=n;try{var r=i.matrixTransform(e.getScreenCTM().inverse()),s=this.getTransformToElement(e).inverse()}catch(t){return i}return r.matrixTransform(s)},n.translateCenterToPoint=function(t){var n=this.getBBox({target:this.svg()}).center();return this.translate(t.x-n.x,t.y-n.y),this},n.translateAndAutoOrient=function(t,n,e){t=new L(t),n=new L(n),e||(e=this.svg());var i=this.scale();this.attr("transform","");var r=this.getBBox({target:e}).scale(i.sx,i.sy),s=q.createSVGTransform();s.setTranslate(-r.x-r.width/2,-r.y-r.height/2);var o=q.createSVGTransform(),a=t.angleBetween(n,t.clone().offset(1,0));a&&o.setRotate(a,0,0);var h=q.createSVGTransform(),u=t.clone().move(n,r.width/2);h.setTranslate(2*t.x-u.x,2*t.y-u.y);var c=this.getTransformToElement(e),l=q.createSVGTransform();return l.setMatrix(h.matrix.multiply(o.matrix.multiply(s.matrix.multiply(c.scale(i.sx,i.sy))))),this.attr("transform",q.matrixToTransformString(l.matrix)),this},n.animateAlongPath=function(t,n){n=q.toNode(n);var e=q.ensureId(n),i=q("animateMotion",t),r=q("mpath",{"xlink:href":"#"+e});i.append(r),this.append(i);try{i.node.beginElement()}catch(t){if("fake"===document.documentElement.getAttribute("smiling")){var s=i.node;s.animators=[];var o=s.getAttribute("id");o&&(id2anim[o]=s);for(var a=getTargets(s),h=0,u=a.length;h<u;h++){var c=a[h],l=new Animator(s,c,h);animators.push(l),(s.animators[h]=l).register()}}}return this};var e=/[^\x20\t\r\n\f]+/g;function r(t){return q.isString(t)&&t.trim().match(e)||[]}n.hasClass=function(t){return!!q.isString(t)&&this.node.classList.contains(t.trim())},n.addClass=function(t){var n;return(n=this.node.classList).add.apply(n,r(t)),this},n.removeClass=function(t){var n;return(n=this.node.classList).remove.apply(n,r(t)),this},n.toggleClass=function(t,n){for(var e=r(t),i=0;i<e.length;i++)this.node.classList.toggle(e[i],n);return this},n.sample=function(t){t=t||1;for(var n,e=this.node,i=e.getTotalLength(),r=[],s=0;s<i;)n=e.getPointAtLength(s),r.push({x:n.x,y:n.y,distance:s}),s+=t;return r},n.convertToPath=function(){var t=q("path");t.attr(this.attr());var n=this.convertToPathData();return n&&t.attr("d",n),t},n.convertToPathData=function(){var t=this.tagName();switch(t){case"PATH":return this.attr("d");case"LINE":return q.convertLineToPathData(this.node);case"POLYGON":return q.convertPolygonToPathData(this.node);case"POLYLINE":return q.convertPolylineToPathData(this.node);case"ELLIPSE":return q.convertEllipseToPathData(this.node);case"CIRCLE":return q.convertCircleToPathData(this.node);case"RECT":return q.convertRectToPathData(this.node)}throw new Error(t+" cannot be converted to PATH.")},q.prototype.toGeometryShape=function(){var t,n,e,i,r,s,o,a,h,u,c,l,f,d,g;switch(this.tagName()){case"RECT":return t=parseFloat(this.attr("x"))||0,n=parseFloat(this.attr("y"))||0,e=parseFloat(this.attr("width"))||0,i=parseFloat(this.attr("height"))||0,new B(t,n,e,i);case"CIRCLE":return r=parseFloat(this.attr("cx"))||0,s=parseFloat(this.attr("cy"))||0,o=parseFloat(this.attr("r"))||0,new D({x:r,y:s},o,o);case"ELLIPSE":return r=parseFloat(this.attr("cx"))||0,s=parseFloat(this.attr("cy"))||0,a=parseFloat(this.attr("rx"))||0,h=parseFloat(this.attr("ry"))||0,new D({x:r,y:s},a,h);case"POLYLINE":return u=q.getPointsFromSvgNode(this),new X(u);case"POLYGON":return 1<(u=q.getPointsFromSvgNode(this)).length&&u.push(u[0]),new X(u);case"PATH":return c=this.attr("d"),et.isDataSupported(c)||(c=q.normalizePathData(c)),new et(c);case"LINE":return l=parseFloat(this.attr("x1"))||0,d=parseFloat(this.attr("y1"))||0,f=parseFloat(this.attr("x2"))||0,g=parseFloat(this.attr("y2"))||0,new N({x:l,y:d},{x:f,y:g})}return this.getBBox()},n.findIntersection=function(t,n){var e=this.svg().node;n=n||e;var i=this.getBBox({target:n}),r=i.center();if(i.intersectionWithLineFromCenterToPoint(t)){var s,o=this.tagName();if("RECT"===o){var a=new B(parseFloat(this.attr("x")||0),parseFloat(this.attr("y")||0),parseFloat(this.attr("width")),parseFloat(this.attr("height"))),h=this.getTransformToElement(n),u=q.decomposeMatrix(h),c=e.createSVGTransform();c.setRotate(-u.rotation,r.x,r.y);var l=q.transformRect(a,c.matrix.multiply(h));s=new B(l).intersectionWithLineFromCenterToPoint(t,u.rotation)}else if("PATH"===o||"POLYGON"===o||"POLYLINE"===o||"CIRCLE"===o||"ELLIPSE"===o){var f,d,g,v,p,m=("PATH"===o?this:this.convertToPath()).sample(),y=1/0,x=[];for(f=0;f<m.length;f++)d=m[f],g=(g=q.createSVGPoint(d.x,d.y)).matrixTransform(this.getTransformToElement(n)),(p=(d=new L(g)).distance(r)+(v=1.1*d.distance(t)))<y?(y=p,x=[{sample:d,refDistance:v}]):p<y+1&&x.push({sample:d,refDistance:v});x.sort(function(t,n){return t.refDistance-n.refDistance}),x[0]&&(s=x[0].sample)}return s}},n.setAttribute=function(t,n){var e=this.node;if(null===n)return this.removeAttr(t),this;var i=q.qualifyAttr(t);return i.ns?e.setAttributeNS(i.ns,t,n):"id"===t?e.id=n:e.setAttribute(t,n),this},q.createSvgDocument=function(t){if(t){var n='<svg xmlns="'+F.svg+'" xmlns:xlink="'+F.xlink+'" version="1.1">'+t+"</svg>";return q.parseXML(n,{async:!1}).documentElement}var e=document.createElementNS(F.svg,"svg");return e.setAttributeNS(F.xmlns,"xmlns:xlink",F.xlink),e.setAttribute("version","1.1"),e},q.createSVGStyle=function(t){return q("style",{type:"text/css"},[q.createCDATASection(t)]).node},q.createCDATASection=function(t){return void 0===t&&(t=""),document.implementation.createDocument(null,"xml",null).createCDATASection(t)},q.idCounter=0,q.uniqueId=function(){return"v-"+ ++q.idCounter},q.toNode=function(t){return q.isV(t)?t.node:t.nodeName&&t||t[0]},q.ensureId=function(t){return(t=q.toNode(t)).id||(t.id=q.uniqueId())},q.sanitizeText=function(t){return(t||"").replace(/ /g,"\xa0")},q.isUndefined=function(t){return void 0===t},q.isString=function(t){return"string"==typeof t},q.isObject=function(t){return t&&"object"==typeof t},q.isArray=Array.isArray,q.parseXML=function(t,n){var e;n=n||{};try{var i=new DOMParser;q.isUndefined(n.async)||(i.async=n.async),e=i.parseFromString(t,"text/xml")}catch(t){e=void 0}if(!e||e.getElementsByTagName("parsererror").length)throw new Error("Invalid XML: "+t);return e},q.qualifyAttr=function(t){if(-1===t.indexOf(":"))return{ns:null,local:t};var n=t.split(":");return{ns:F[n[0]],local:n[1]}},q.transformSeparatorRegex=/[ ,]+/,q.transformRegex=/\b\w+\([^()]+\)/g,q.transformFunctionRegex=/\b(\w+)\(([^()]+)\)/,q.transformTranslateRegex=/\btranslate\(([^()]+)\)/,q.transformRotateRegex=/\brotate\(([^()]+)\)/,q.transformScaleRegex=/\bscale\(([^()]+)\)/,q.transformStringToMatrix=function(t){var n=q.createSVGMatrix(),e=t&&t.match(q.transformRegex);if(!e)return n;for(var i=e.length,r=0;r<i;r++){var s=e[r].match(q.transformFunctionRegex);if(s){var o=void 0,a=void 0,h=void 0,u=void 0,c=void 0,l=q.createSVGMatrix(),f=s[1].toLowerCase(),d=s[2].split(q.transformSeparatorRegex);switch(f){case"scale":o=parseFloat(d[0]),a=void 0===d[1]?o:parseFloat(d[1]),l=l.scaleNonUniform(o,a);break;case"translate":h=parseFloat(d[0]),u=parseFloat(d[1]),l=l.translate(h,u);break;case"rotate":c=parseFloat(d[0]),h=parseFloat(d[1])||0,u=parseFloat(d[2])||0,l=0!==h||0!==u?l.translate(h,u).rotate(c).translate(-h,-u):l.rotate(c);break;case"skewx":c=parseFloat(d[0]),l=l.skewX(c);break;case"skewy":c=parseFloat(d[0]),l=l.skewY(c);break;case"matrix":l.a=parseFloat(d[0]),l.b=parseFloat(d[1]),l.c=parseFloat(d[2]),l.d=parseFloat(d[3]),l.e=parseFloat(d[4]),l.f=parseFloat(d[5]);break;default:continue}n=n.multiply(l)}}return n},q.matrixToTransformString=function(t){return t||(t=!0),"matrix("+(void 0!==t.a?t.a:1)+","+(void 0!==t.b?t.b:0)+","+(void 0!==t.c?t.c:0)+","+(void 0!==t.d?t.d:1)+","+(void 0!==t.e?t.e:0)+","+(void 0!==t.f?t.f:0)+")"},q.parseTransformString=function(t){var n,e,i;if(t){var r=q.transformSeparatorRegex;if(0<=t.trim().indexOf("matrix")){var s=q.transformStringToMatrix(t),o=q.decomposeMatrix(s);n=[o.translateX,o.translateY],i=[o.scaleX,o.scaleY],e=[o.rotation];var a=[];0===n[0]&&0===n[1]||a.push("translate("+n+")"),1===i[0]&&1===i[1]||a.push("scale("+i+")"),0!==e[0]&&a.push("rotate("+e+")"),t=a.join(" ")}else{var h=t.match(q.transformTranslateRegex);h&&(n=h[1].split(r));var u=t.match(q.transformRotateRegex);u&&(e=u[1].split(r));var c=t.match(q.transformScaleRegex);c&&(i=c[1].split(r))}}var l=i&&i[0]?parseFloat(i[0]):1;return{value:t,translate:{tx:n&&n[0]?parseInt(n[0],10):0,ty:n&&n[1]?parseInt(n[1],10):0},rotate:{angle:e&&e[0]?parseInt(e[0],10):0,cx:e&&e[1]?parseInt(e[1],10):void 0,cy:e&&e[2]?parseInt(e[2],10):void 0},scale:{sx:l,sy:i&&i[1]?parseFloat(i[1]):l}}},q.deltaTransformPoint=function(t,n){return{x:n.x*t.a+n.y*t.c+0,y:n.x*t.b+n.y*t.d+0}},q.decomposeMatrix=function(t){var n=q.deltaTransformPoint(t,{x:0,y:1}),e=q.deltaTransformPoint(t,{x:1,y:0}),i=180/v*s(n.y,n.x)-90,r=180/v*s(e.y,e.x);return{translateX:t.e,translateY:t.f,scaleX:o(t.a*t.a+t.b*t.b),scaleY:o(t.c*t.c+t.d*t.d),skewX:i,skewY:r,rotation:i}},q.matrixToScale=function(t){var n,e,i,r;return t?(n=q.isUndefined(t.a)?1:t.a,r=q.isUndefined(t.d)?1:t.d,e=t.b,i=t.c):n=r=1,{sx:e?o(n*n+e*e):n,sy:i?o(i*i+r*r):r}},q.matrixToRotate=function(t){var n={x:0,y:1};return t&&(n=q.deltaTransformPoint(t,n)),{angle:a(c(s(n.y,n.x))-90)}},q.matrixToTranslate=function(t){return{tx:t&&t.e||0,ty:t&&t.f||0}},q.isV=function(t){return t instanceof q},q.isVElement=q.isV,q.isSVGGraphicsElement=function(t){return!!t&&((t=q.toNode(t))instanceof SVGElement&&"function"==typeof t.getScreenCTM)};var d=q("svg").node;return q.createSVGMatrix=function(t){var n=d.createSVGMatrix();for(var e in t)n[e]=t[e];return n},q.createSVGTransform=function(t){return q.isUndefined(t)?d.createSVGTransform():(t instanceof SVGMatrix||(t=q.createSVGMatrix(t)),d.createSVGTransformFromMatrix(t))},q.createSVGPoint=function(t,n){var e=d.createSVGPoint();return e.x=t,e.y=n,e},q.transformRect=function(t,n){var e=d.createSVGPoint();e.x=t.x,e.y=t.y;var i=e.matrixTransform(n);e.x=t.x+t.width,e.y=t.y;var r=e.matrixTransform(n);e.x=t.x+t.width,e.y=t.y+t.height;var s=e.matrixTransform(n);e.x=t.x,e.y=t.y+t.height;var o=e.matrixTransform(n),a=l(i.x,r.x,s.x,o.x),h=f(i.x,r.x,s.x,o.x),u=l(i.y,r.y,s.y,o.y),c=f(i.y,r.y,s.y,o.y);return new B(a,u,h-a,c-u)},q.transformPoint=function(t,n){return new L(q.createSVGPoint(t.x,t.y).matrixTransform(n))},q.transformLine=function(t,n){return new N(q.transformPoint(t.start,n),q.transformPoint(t.end,n))},q.transformPolyline=function(t,n){var e=t instanceof X?t.points:t;q.isArray(e)||(e=[]);for(var i=[],r=0,s=e.length;r<s;r++)i[r]=q.transformPoint(e[r],n);return new X(i)},q.styleToObject=function(t){for(var n={},e=t.split(";"),i=0;i<e.length;i++){var r=e[i].split("=");n[r[0].trim()]=r[1].trim()}return n},q.createSlicePathData=function(t,n,e,i){var r=2*v-1e-6,s=t,o=n,a=e,h=i,u=(h<a&&(u=a,a=h,h=u),h-a),c=u<v?"0":"1",l=p(a),f=m(a),d=p(h),g=m(h);return r<=u?s?"M0,"+o+"A"+o+","+o+" 0 1,1 0,"+-o+"A"+o+","+o+" 0 1,1 0,"+o+"M0,"+s+"A"+s+","+s+" 0 1,0 0,"+-s+"A"+s+","+s+" 0 1,0 0,"+s+"Z":"M0,"+o+"A"+o+","+o+" 0 1,1 0,"+-o+"A"+o+","+o+" 0 1,1 0,"+o+"Z":s?"M"+o*l+","+o*f+"A"+o+","+o+" 0 "+c+",1 "+o*d+","+o*g+"L"+s*d+","+s*g+"A"+s+","+s+" 0 "+c+",0 "+s*l+","+s*f+"Z":"M"+o*l+","+o*f+"A"+o+","+o+" 0 "+c+",1 "+o*d+","+o*g+"L0,0Z"},q.mergeAttrs=function(t,n){for(var e in n)"class"===e?t[e]=t[e]?t[e]+" "+n[e]:n[e]:"style"===e?q.isObject(t[e])&&q.isObject(n[e])?t[e]=q.mergeAttrs(t[e],n[e]):q.isObject(t[e])?t[e]=q.mergeAttrs(t[e],q.styleToObject(n[e])):q.isObject(n[e])?t[e]=q.mergeAttrs(q.styleToObject(t[e]),n[e]):t[e]=q.mergeAttrs(q.styleToObject(t[e]),q.styleToObject(n[e])):t[e]=n[e];return t},q.annotateString=function(t,n,e){n=n||[];for(var i,r,s,o=(e=e||{}).offset||0,a=[],h=[],u=0;u<t.length;u++){r=h[u]=t[u];for(var c=0;c<n.length;c++){var l=n[c],f=l.start+o,d=l.end+o;f<=u&&u<d&&(q.isObject(r)?r.attrs=q.mergeAttrs(q.mergeAttrs({},r.attrs),l.attrs):r=h[u]={t:t[u],attrs:l.attrs},e.includeAnnotationIndices&&(r.annotations||(r.annotations=[])).push(c))}(s=h[u-1])?q.isObject(r)&&q.isObject(s)?JSON.stringify(r.attrs)===JSON.stringify(s.attrs)?i.t+=r.t:(a.push(i),i=r):i=q.isObject(r)?(a.push(i),r):q.isObject(s)?(a.push(i),r):(i||"")+r:i=r}return i&&a.push(i),a},q.findAnnotationsAtIndex=function(t,n){var e=[];return t&&t.forEach(function(t){t.start<n&&n<=t.end&&e.push(t)}),e},q.findAnnotationsBetweenIndexes=function(t,n,e){var i=[];return t&&t.forEach(function(t){(n>=t.start&&n<t.end||e>t.start&&e<=t.end||t.start>=n&&t.end<e)&&i.push(t)}),i},q.shiftAnnotations=function(t,n,e){return t&&t.forEach(function(t){t.start<n&&t.end>=n?t.end+=e:t.start>=n&&(t.start+=e,t.end+=e)}),t},q.convertLineToPathData=function(t){return["M",(t=q(t)).attr("x1"),t.attr("y1"),"L",t.attr("x2"),t.attr("y2")].join(" ")},q.convertPolygonToPathData=function(t){var n=q.getPointsFromSvgNode(t);return 0===n.length?null:q.svgPointsToPath(n)+" Z"},q.convertPolylineToPathData=function(t){var n=q.getPointsFromSvgNode(t);return 0===n.length?null:q.svgPointsToPath(n)},q.svgPointsToPath=function(t){for(var n=0,e=t.length;n<e;n++)t[n]=t[n].x+" "+t[n].y;return"M "+t.join(" L")},q.getPointsFromSvgNode=function(t){var n=[],e=(t=q.toNode(t)).points;if(e)for(var i=0,r=e.numberOfItems;i<r;i++)n.push(e.getItem(i));return n},q.KAPPA=.551784,q.convertCircleToPathData=function(t){t=q(t);var n=parseFloat(t.attr("cx"))||0,e=parseFloat(t.attr("cy"))||0,i=parseFloat(t.attr("r")),r=i*q.KAPPA;return["M",n,e-i,"C",n+r,e-i,n+i,e-r,n+i,e,"C",n+i,e+r,n+r,e+i,n,e+i,"C",n-r,e+i,n-i,e+r,n-i,e,"C",n-i,e-r,n-r,e-i,n,e-i,"Z"].join(" ")},q.convertEllipseToPathData=function(t){t=q(t);var n=parseFloat(t.attr("cx"))||0,e=parseFloat(t.attr("cy"))||0,i=parseFloat(t.attr("rx")),r=parseFloat(t.attr("ry"))||i,s=i*q.KAPPA,o=r*q.KAPPA;return["M",n,e-r,"C",n+s,e-r,n+i,e-o,n+i,e,"C",n+i,e+o,n+s,e+r,n,e+r,"C",n-s,e+r,n-i,e+o,n-i,e,"C",n-i,e-o,n-s,e-r,n,e-r,"Z"].join(" ")},q.convertRectToPathData=function(t){return t=q(t),q.rectToPath({x:parseFloat(t.attr("x"))||0,y:parseFloat(t.attr("y"))||0,width:parseFloat(t.attr("width"))||0,height:parseFloat(t.attr("height"))||0,rx:parseFloat(t.attr("rx"))||0,ry:parseFloat(t.attr("ry"))||0})},q.rectToPath=function(t){var n=t.x,e=t.y,i=t.width,r=t.height,s=l(t.rx||t["top-rx"]||0,i/2),o=l(t.rx||t["bottom-rx"]||0,i/2),a=l(t.ry||t["top-ry"]||0,r/2),h=l(t.ry||t["bottom-ry"]||0,r/2);return(s||o||a||h?["M",n,e+a,"v",r-a-h,"a",o,h,0,0,0,o,h,"h",i-2*o,"a",o,h,0,0,0,o,-h,"v",-(r-h-a),"a",s,a,0,0,0,-s,-a,"h",-(i-2*s),"a",s,a,0,0,0,-s,a,"Z"]:["M",n,e,"H",n+i,"V",e+r,"H",n,"V",e,"Z"]).join(" ")},q.normalizePathData=function(){var t="\t\n\v\f\r \xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029",v=new RegExp("([a-z])["+t+",]*((-?\\d*\\.?\\d*(?:e[\\-+]?\\d+)?["+t+"]*,?["+t+"]*)+)","ig"),p=new RegExp("(-?\\d*\\.?\\d*(?:e[\\-+]?\\d+)?)["+t+"]*,?["+t+"]*","ig"),n=Math,B=n.PI,H=n.sin,U=n.cos,Z=n.tan,Y=n.asin,X=n.sqrt,J=n.abs;function f(t,n,e,i,r,s){return[1/3*t+2/3*e,1/3*n+2/3*i,1/3*r+2/3*e,1/3*s+2/3*i,r,s]}function K(t,n,e){return{x:t*U(e)-n*H(e),y:t*H(e)+n*U(e)}}function d(t){if(Array.isArray(t)&&Array.isArray(t&&t[0])||(t=function(t){if(!t)return null;var s={a:7,c:6,h:1,l:2,m:2,q:4,s:4,t:2,v:1,z:0},o=[];return String(t).replace(v,function(t,n,e){var i=[],r=n.toLowerCase();for(e.replace(p,function(t,n){n&&i.push(+n)}),"m"===r&&2<i.length&&(o.push([n].concat(i.splice(0,2))),r="l",n="m"===n?"l":"L");i.length>=s[r]&&(o.push([n].concat(i.splice(0,s[r]))),s[r]););}),o}(t)),!t||!t.length)return[["M",0,0]];for(var n,e=[],i=0,r=0,s=0,o=0,a=t.length,h=0;h<a;h++){var u=[];e.push(u);var c,l,f=t[h];if((n=f[0])!=n.toUpperCase())switch(u[0]=n.toUpperCase(),u[0]){case"A":u[1]=f[1],u[2]=f[2],u[3]=f[3],u[4]=f[4],u[5]=f[5],u[6]=+f[6]+i,u[7]=+f[7]+r;break;case"V":u[1]=+f[1]+r;break;case"H":u[1]=+f[1]+i;break;case"M":for(s=+f[1]+i,o=+f[2]+r,c=f.length,l=1;l<c;l++)u[l]=+f[l]+(l%2?i:r);break;default:for(c=f.length,l=1;l<c;l++)u[l]=+f[l]+(l%2?i:r)}else for(var d=f.length,g=0;g<d;g++)u[g]=f[g];switch(u[0]){case"Z":i=+s,r=+o;break;case"H":i=u[1];break;case"V":r=u[1];break;case"M":s=u[u.length-2],o=u[u.length-1],i=u[u.length-2],r=u[u.length-1];break;default:i=u[u.length-2],r=u[u.length-1]}}return e}function e(t){var i=d(t),n={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null};function e(t,n,e){var i,r;if(!t)return["C",n.x,n.y,n.x,n.y,n.x,n.y];switch(t[0]in{T:1,Q:1}||(n.qx=null,n.qy=null),t[0]){case"M":n.X=t[1],n.Y=t[2];break;case"A":t=0===parseFloat(t[1])||0===parseFloat(t[2])?["L",t[6],t[7]]:["C"].concat(function t(n,e,i,r,s,o,a,h,u,c){var l,f=120*B/180,d=B/180*(+s||0),g=[];if(c)P=c[0],A=c[1],b=c[2],S=c[3];else{n=(l=K(n,e,-d)).x,e=l.y;var v=(n-(h=(l=K(h,u,-d)).x))/2,p=(e-(u=l.y))/2,m=v*v/(i*i)+p*p/(r*r);1<m&&(i*=m=X(m),r*=m);var y=i*i,x=r*r,w=(o==a?-1:1)*X(J((y*x-y*p*p-x*v*v)/(y*p*p+x*v*v))),b=w*i*p/r+(n+h)/2,S=w*-r*v/i+(e+u)/2,P=Y(((e-S)/r).toFixed(9)),A=Y(((u-S)/r).toFixed(9));(P=n<b?B-P:P)<0&&(P=2*B+P),(A=h<b?B-A:A)<0&&(A=2*B+A),a&&A<P&&(P-=2*B),!a&&P<A&&(A-=2*B)}var T=A-P;if(J(T)>f){var L=A,E=h,C=u;g=t(h=b+i*U(A=P+f*(a&&P<A?1:-1)),u=S+r*H(A),i,r,s,0,a,E,C,[A,L,b,S])}T=A-P;var N=U(P),I=H(P),M=U(A),R=H(A),O=Z(T/4),D=4/3*(i*O),F=4/3*(r*O),q=[n,e],V=[n+D*I,e-F*N],z=[h+D*R,u-F*M],k=[h,u];if(V[0]=2*q[0]-V[0],V[1]=2*q[1]-V[1],c)return[V,z,k].concat(g);for(var j=[],G=(g=[V,z,k].concat(g).join().split(",")).length,W=0;W<G;W++)j[W]=W%2?K(g[W-1],g[W],d).y:K(g[W],g[W+1],d).x;return j}.apply(0,[n.x,n.y].concat(t.slice(1))));break;case"S":r="C"===e||"S"===e?(i=2*n.x-n.bx,2*n.y-n.by):(i=n.x,n.y),t=["C",i,r].concat(t.slice(1));break;case"T":"Q"===e||"T"===e?(n.qx=2*n.x-n.qx,n.qy=2*n.y-n.qy):(n.qx=n.x,n.qy=n.y),t=["C"].concat(f(n.x,n.y,n.qx,n.qy,t[1],t[2]));break;case"Q":n.qx=t[1],n.qy=t[2],t=["C"].concat(f(n.x,n.y,t[1],t[2],t[3],t[4]));break;case"H":t=["L"].concat(t[1],n.y);break;case"V":t=["L"].concat(n.x,t[1])}return t}function r(t,n){if(7<t[n].length){t[n].shift();for(var e=t[n];e.length;)s[n]="A",t.splice(n++,0,["C"].concat(e.splice(0,6)));t.splice(n,1),h=i.length}}for(var s=[],o="",a="",h=i.length,u=0;u<h;u++){i[u]&&(o=i[u][0]),"C"!==o&&(s[u]=o,0<u&&(a=s[u-1])),i[u]=e(i[u],n,a),"A"!==s[u]&&"C"===o&&(s[u]="C"),r(i,u);var c=i[u],l=c.length;n.x=c[l-2],n.y=c[l-1],n.bx=parseFloat(c[l-4])||n.x,n.by=parseFloat(c[l-3])||n.y}return i[0][0]&&"M"===i[0][0]||i.unshift(["M",0,0]),i}return function(t){return e(t).join(",").split(",").join(" ")}}(),q.namespace=F,q.g=Ut,q}()}),"undefined"!=typeof V)var g=V.g,Vectorizer=V;