/*! JointJS v3.7.1 (2023-04-28) - JavaScript diagramming library


This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at http://mozilla.org/MPL/2.0/.
*/
!function(t,n){"object"==typeof exports&&"undefined"!=typeof module?n(exports):"function"==typeof define&&define.amd?define(["exports"],n):n((t=t||self).g={})}(this,function(t){"use strict";var e=Math.round,i=Math.floor,r=Math.PI,o=function(t){return t%360+(t<0?360:0)},s=function(t,n){return n*e(t/n)},c=function(t){return 180*t/r%360},l=function(t,n){return(t=(n=n||!1)?t:t%360)*r/180},h=function(t,n){if(void 0===n)n=void 0===t?1:t,t=0;else if(n<t){var e=t;t=n,n=e}return i(Math.random()*(n-t+1)+t)},f=Math.cos,d=Math.sin,g=Math.atan2,n=function(t,n){var e=l(t.y),i=l(n.y),r=t.x,s=n.x,o=l(s-r),h=d(o)*f(i),u=f(e)*d(i)-d(e)*f(i)*f(o),a=c(g(h,u))-22.5;return a<0&&(a+=360),["NE","E","SE","S","SW","W","NW","N"][a=parseInt(a/45)]},u=function(t,n){var e=t.x,i=t.y;return(e-=n.x)*e+(i-=n.y)*i},a=function(t,n){return Math.sqrt(u(t,n))},v={Point:1,Line:2,Ellipse:3,Rect:4,Polyline:5,Polygon:6,Curve:7,Path:8},p=Math.abs,y=Math.cos,w=Math.sin,m=Math.sqrt,x=Math.min,b=Math.max,S=Math.atan2,P=Math.round,A=Math.pow,L=Math.PI,E=function(t,n){if(!(this instanceof E))return new E(t,n);if("string"==typeof t){var e=t.split(-1===t.indexOf("@")?" ":"@");t=parseFloat(e[0]),n=parseFloat(e[1])}else Object(t)===t&&(n=t.y,t=t.x);this.x=void 0===t?0:t,this.y=void 0===n?0:n};E.fromPolar=function(t,n,e){e=new E(e);var i=p(t*y(n)),r=p(t*w(n)),s=o(c(n));return s<90?r=-r:s<180?(i=-i,r=-r):s<270&&(i=-i),new E(e.x+i,e.y+r)},E.random=function(t,n,e,i){return new E(h(t,n),h(e,i))},E.prototype={type:v.Point,chooseClosest:function(t){var n=t.length;if(1===n)return new E(t[0]);for(var e=null,i=1/0,r=0;r<n;r++){var s=new E(t[r]),o=this.squaredDistance(s);o<i&&(e=s,i=o)}return e},adhereToRect:function(t){return t.containsPoint(this)||(this.x=x(b(this.x,t.x),t.x+t.width),this.y=x(b(this.y,t.y),t.y+t.height)),this},angleBetween:function(t,n){var e=this.equals(t)||this.equals(n)?NaN:this.theta(n)-this.theta(t);return e<0&&(e+=360),e},bearing:function(t){return n(this,t)},changeInAngle:function(t,n,e){return this.clone().offset(-t,-n).theta(e)-this.theta(e)},clone:function(){return new E(this)},cross:function(t,n){return t&&n?(n.x-this.x)*(t.y-this.y)-(n.y-this.y)*(t.x-this.x):NaN},difference:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),new E(this.x-(t||0),this.y-(n||0))},distance:function(t){return a(this,t)},dot:function(t){return t?this.x*t.x+this.y*t.y:NaN},equals:function(t){return!!t&&this.x===t.x&&this.y===t.y},lerp:function(t,n){var e=this.x,i=this.y;return new E((1-n)*e+n*t.x,(1-n)*i+n*t.y)},magnitude:function(){return m(this.x*this.x+this.y*this.y)||.01},manhattanDistance:function(t){return p(t.x-this.x)+p(t.y-this.y)},move:function(t,n){var e=l(new E(t).theta(this));return this.offset(y(e)*n,-w(e)*n)},normalize:function(t){var n=(t||1)/this.magnitude();return this.scale(n,n)},offset:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),this.x+=t||0,this.y+=n||0,this},reflection:function(t){return new E(t).move(this,this.distance(t))},rotate:function(t,n){if(0===n)return this;t=t||new E(0,0),n=l(o(-n));var e=y(n),i=w(n),r=e*(this.x-t.x)-i*(this.y-t.y)+t.x,s=i*(this.x-t.x)+e*(this.y-t.y)+t.y;return this.x=r,this.y=s,this},round:function(t){var n=1;if(t)switch(t){case 1:n=10;break;case 2:n=100;break;case 3:n=1e3;break;default:n=A(10,t)}return this.x=P(this.x*n)/n,this.y=P(this.y*n)/n,this},scale:function(t,n,e){return e=e&&new E(e)||new E(0,0),this.x=e.x+t*(this.x-e.x),this.y=e.y+n*(this.y-e.y),this},snapToGrid:function(t,n){return this.x=s(this.x,t),this.y=s(this.y,n||t),this},squaredDistance:function(t){return u(this,t)},theta:function(t){var n=-((t=new E(t)).y-this.y),e=t.x-this.x,i=S(n,e);return i<0&&(i=2*L+i),180*i/L},toJSON:function(){return{x:this.x,y:this.y}},toPolar:function(t){t=t&&new E(t)||new E(0,0);var n=this.x,e=this.y;return this.x=m((n-t.x)*(n-t.x)+(e-t.y)*(e-t.y)),this.y=l(t.theta(new E(n,e))),this},toString:function(){return this.x+"@"+this.y},serialize:function(){return this.x+","+this.y},update:function(t,n){return Object(t)===t&&(n=t.y,t=t.x),this.x=t||0,this.y=n||0,this},vectorAngle:function(t){return new E(0,0).angleBetween(this,t)}},E.prototype.translate=E.prototype.offset;var T=E,I=Math.max,C=Math.min,R=function(t,n){return this instanceof R?t instanceof R?new R(t.start,t.end):(this.start=new E(t),void(this.end=new E(n))):new R(t,n)};R.prototype={type:v.Line,angle:function(){var t=new E(this.start.x+1,this.start.y);return this.start.angleBetween(this.end,t)},bbox:function(){var t=C(this.start.x,this.end.x),n=C(this.start.y,this.end.y),e=I(this.start.x,this.end.x),i=I(this.start.y,this.end.y);return new G(t,n,e-t,i-n)},bearing:function(){return n(this.start,this.end)},clone:function(){return new R(this.start,this.end)},closestPoint:function(t){return this.pointAt(this.closestPointNormalizedLength(t))},closestPointLength:function(t){return this.closestPointNormalizedLength(t)*this.length()},closestPointNormalizedLength:function(t){var n=this.vector().dot(new R(this.start,t).vector()),e=C(1,I(0,n/this.squaredLength()));return e!=e?0:e},closestPointTangent:function(t){return this.tangentAt(this.closestPointNormalizedLength(t))},containsPoint:function(t){var n=this.start,e=this.end;if(0!==n.cross(t,e))return!1;var i=this.length();return!(new R(n,t).length()>i)&&!(new R(t,e).length()>i)},divideAt:function(t){var n=this.pointAt(t);return[new R(this.start,n),new R(n,this.end)]},divideAtLength:function(t){var n=this.pointAtLength(t);return[new R(this.start,n),new R(n,this.end)]},equals:function(t){return!!t&&this.start.x===t.start.x&&this.start.y===t.start.y&&this.end.x===t.end.x&&this.end.y===t.end.y},intersect:function(t,n){if(t&&t.intersectionWithLine){var e=t.intersectionWithLine(this,n);return e&&t instanceof R&&(e=e[0]),e}return null},intersectionWithLine:function(t){var n=new E(this.end.x-this.start.x,this.end.y-this.start.y),e=new E(t.end.x-t.start.x,t.end.y-t.start.y),i=n.x*e.y-n.y*e.x,r=new E(t.start.x-this.start.x,t.start.y-this.start.y),s=r.x*e.y-r.y*e.x,o=r.x*n.y-r.y*n.x;if(0===i||s*i<0||o*i<0)return null;if(0<i){if(i<s||i<o)return null}else if(s<i||o<i)return null;return[new E(this.start.x+s*n.x/i,this.start.y+s*n.y/i)]},isDifferentiable:function(){return!this.start.equals(this.end)},length:function(){return a(this.start,this.end)},midpoint:function(){return new E((this.start.x+this.end.x)/2,(this.start.y+this.end.y)/2)},parallel:function(t){var n=this.clone();if(!this.isDifferentiable())return n;var e=n.start,i=n.end,r=e.clone().rotate(i,270),s=i.clone().rotate(e,90);return e.move(s,t),i.move(r,t),n},pointAt:function(t){var n=this.start,e=this.end;return t<=0?n.clone():1<=t?e.clone():n.lerp(e,t)},pointAtLength:function(t){var n=this.start,e=this.end,i=!0;t<0&&(i=!1,t=-t);var r=this.length();return r<=t?i?e.clone():n.clone():this.pointAt((i?t:r-t)/r)},pointOffset:function(t){t=new E(t);var n=this.start,e=this.end;return((e.x-n.x)*(t.y-n.y)-(e.y-n.y)*(t.x-n.x))/this.length()},rotate:function(t,n){return this.start.rotate(t,n),this.end.rotate(t,n),this},round:function(t){return this.start.round(t),this.end.round(t),this},scale:function(t,n,e){return this.start.scale(t,n,e),this.end.scale(t,n,e),this},setLength:function(t){var n=this.length();if(!n)return this;var e=t/n;return this.scale(e,e,this.start)},squaredLength:function(){return u(this.start,this.end)},tangentAt:function(t){if(!this.isDifferentiable())return null;var n=this.start,e=this.end,i=this.pointAt(t),r=new R(n,e);return r.translate(i.x-n.x,i.y-n.y),r},tangentAtLength:function(t){if(!this.isDifferentiable())return null;var n=this.start,e=this.end,i=this.pointAtLength(t),r=new R(n,e);return r.translate(i.x-n.x,i.y-n.y),r},toString:function(){return this.start.toString()+" "+this.end.toString()},serialize:function(){return this.start.serialize()+" "+this.end.serialize()},translate:function(t,n){return this.start.translate(t,n),this.end.translate(t,n),this},vector:function(){return new E(this.end.x-this.start.x,this.end.y-this.start.y)}},R.prototype.intersection=R.prototype.intersect;var D=R,M=Math.sqrt,O=Math.round,N=Math.pow,q=function(t,n,e){return this instanceof q?t instanceof q?new q(new E(t.x,t.y),t.a,t.b):(t=new E(t),this.x=t.x,this.y=t.y,this.a=n,void(this.b=e)):new q(t,n,e)};q.fromRect=function(t){return t=new G(t),new q(t.center(),t.width/2,t.height/2)},q.prototype={type:v.Ellipse,bbox:function(){return new G(this.x-this.a,this.y-this.b,2*this.a,2*this.b)},center:function(){return new E(this.x,this.y)},clone:function(){return new q(this)},containsPoint:function(t){return this.normalizedDistance(t)<=1},equals:function(t){return!!t&&t.x===this.x&&t.y===this.y&&t.a===this.a&&t.b===this.b},inflate:function(t,n){return void 0===t&&(t=0),void 0===n&&(n=t),this.a+=2*t,this.b+=2*n,this},intersectionWithLine:function(t){var n=[],e=t.start,i=t.end,r=this.a,s=this.b,o=t.vector(),h=e.difference(new E(this)),u=new E(o.x/(r*r),o.y/(s*s)),a=new E(h.x/(r*r),h.y/(s*s)),c=o.dot(u),l=o.dot(a),f=l*l-c*(h.dot(a)-1);if(f<0)return null;if(0<f){var d=M(f),g=(-l-d)/c,v=(-l+d)/c;if((g<0||1<g)&&(v<0||1<v))return null;0<=g&&g<=1&&n.push(e.lerp(i,g)),0<=v&&v<=1&&n.push(e.lerp(i,v))}else{var p=-l/c;if(!(0<=p&&p<=1))return null;n.push(e.lerp(i,p))}return n},intersectionWithLineFromCenterToPoint:function(t,n){t=new E(t),n&&t.rotate(new E(this.x,this.y),n);var e,i=t.x-this.x,r=t.y-this.y;if(0===i)return e=this.bbox().pointNearestToPoint(t),n?e.rotate(new E(this.x,this.y),-n):e;var s=r/i,o=s*s,h=this.a*this.a,u=this.b*this.b,a=M(1/(1/h+o/u)),c=s*(a=i<0?-a:a);return e=new E(this.x+a,this.y+c),n?e.rotate(new E(this.x,this.y),-n):e},normalizedDistance:function(t){var n=t.x,e=t.y,i=this.a,r=this.b,s=this.x,o=this.y;return(n-s)*(n-s)/(i*i)+(e-o)*(e-o)/(r*r)},round:function(t){var n=1;if(t)switch(t){case 1:n=10;break;case 2:n=100;break;case 3:n=1e3;break;default:n=N(10,t)}return this.x=O(this.x*n)/n,this.y=O(this.y*n)/n,this.a=O(this.a*n)/n,this.b=O(this.b*n)/n,this},tangentTheta:function(t){var n,e,i=t.x,r=t.y,s=this.a,o=this.b,h=this.bbox().center(),u=h.x,a=h.y,c=i>h.x+s/2,l=i<h.x-s/2;return c||l?e=s*s/(i-u)-s*s*(r-a)*((n=i>h.x?r-30:r+30)-a)/(o*o*(i-u))+u:n=o*o/(r-a)-o*o*(i-u)*((e=r>h.y?i+30:i-30)-u)/(s*s*(r-a))+a,new E(e,n).theta(t)},toString:function(){return new E(this.x,this.y).toString()+" "+this.a+" "+this.b}};var z=q,W=Math.abs,j=Math.cos,k=Math.sin,V=Math.min,F=Math.max,Z=Math.round,B=Math.pow,G=function(t,n,e,i){if(!(this instanceof G))return new G(t,n,e,i);Object(t)===t&&(n=t.y,e=t.width,i=t.height,t=t.x),this.x=void 0===t?0:t,this.y=void 0===n?0:n,this.width=void 0===e?0:e,this.height=void 0===i?0:i};G.fromEllipse=function(t){return t=new q(t),new G(t.x-t.a,t.y-t.b,2*t.a,2*t.b)},G.fromPointUnion=function(){for(var t=[],n=arguments.length;n--;)t[n]=arguments[n];if(0===t.length)return null;var e,i,r,s,o=new E;e=i=1/0,r=s=-1/0;for(var h=0;h<t.length;h++){o.update(t[h]);var u=o.x,a=o.y;u<e&&(e=u),r<u&&(r=u),a<i&&(i=a),s<a&&(s=a)}return new G(e,i,r-e,s-i)},G.fromRectUnion=function(){for(var t=[],n=arguments.length;n--;)t[n]=arguments[n];if(0===t.length)return null;var e,i,r,s,o=new G;e=i=1/0,r=s=-1/0;for(var h=0;h<t.length;h++){o.update(t[h]);var u=o.x,a=o.y,c=u+o.width,l=a+o.height;u<e&&(e=u),r<c&&(r=c),a<i&&(i=a),s<l&&(s=l)}return new G(e,i,r-e,s-i)},G.prototype={type:v.Rect,bbox:function(t){return this.clone().rotateAroundCenter(t)},rotateAroundCenter:function(t){if(!t)return this;var n=this.width,e=this.height,i=l(t),r=W(k(i)),s=W(j(i)),o=n*s+e*r,h=n*r+e*s;return this.x+=(n-o)/2,this.y+=(e-h)/2,this.width=o,this.height=h,this},bottomLeft:function(){return new E(this.x,this.y+this.height)},bottomLine:function(){return new R(this.bottomLeft(),this.bottomRight())},bottomMiddle:function(){return new E(this.x+this.width/2,this.y+this.height)},center:function(){return new E(this.x+this.width/2,this.y+this.height/2)},clone:function(){return new G(this)},containsPoint:function(t){return(t=new E(t)).x>=this.x&&t.x<=this.x+this.width&&t.y>=this.y&&t.y<=this.y+this.height},containsRect:function(t){var n=new G(this).normalize(),e=new G(t).normalize(),i=n.width,r=n.height,s=e.width,o=e.height;if(!(i&&r&&s&&o))return!1;var h=n.x,u=n.y,a=e.x,c=e.y;return s+=a,i+=h,o+=c,r+=u,h<=a&&s<=i&&u<=c&&o<=r},corner:function(){return new E(this.x+this.width,this.y+this.height)},equals:function(t){var n=new G(this).normalize(),e=new G(t).normalize();return n.x===e.x&&n.y===e.y&&n.width===e.width&&n.height===e.height},inflate:function(t,n){return void 0===t&&(t=0),void 0===n&&(n=t),this.x-=t,this.y-=n,this.width+=2*t,this.height+=2*n,this},intersect:function(t){var n=this.origin(),e=this.corner(),i=t.origin(),r=t.corner();if(r.x<=n.x||r.y<=n.y||i.x>=e.x||i.y>=e.y)return null;var s=F(n.x,i.x),o=F(n.y,i.y);return new G(s,o,V(e.x,r.x)-s,V(e.y,r.y)-o)},intersectionWithLine:function(t){var n,e,i=[this.topLine(),this.rightLine(),this.bottomLine(),this.leftLine()],r=[],s=[],o=i.length;for(e=0;e<o;e++)null!==(n=t.intersect(i[e]))&&s.indexOf(n.toString())<0&&(r.push(n),s.push(n.toString()));return 0<r.length?r:null},intersectionWithLineFromCenterToPoint:function(t,n){t=new E(t);var e,i=new E(this.x+this.width/2,this.y+this.height/2);n&&t.rotate(i,n);for(var r=[this.topLine(),this.rightLine(),this.bottomLine(),this.leftLine()],s=new R(i,t),o=r.length-1;0<=o;--o){var h=r[o].intersection(s);if(null!==h){e=h;break}}return e&&n&&e.rotate(i,-n),e},leftLine:function(){return new R(this.topLeft(),this.bottomLeft())},leftMiddle:function(){return new E(this.x,this.y+this.height/2)},maxRectScaleToFit:function(t,n){var e,i,r,s,o,h,u,a;t=new G(t),n||(n=t.center());var c=n.x,l=n.y;e=i=r=s=o=h=u=a=1/0;var f=t.topLeft();f.x<c&&(e=(this.x-c)/(f.x-c)),f.y<l&&(o=(this.y-l)/(f.y-l));var d=t.bottomRight();d.x>c&&(i=(this.x+this.width-c)/(d.x-c)),d.y>l&&(h=(this.y+this.height-l)/(d.y-l));var g=t.topRight();g.x>c&&(r=(this.x+this.width-c)/(g.x-c)),g.y<l&&(u=(this.y-l)/(g.y-l));var v=t.bottomLeft();return v.x<c&&(s=(this.x-c)/(v.x-c)),v.y>l&&(a=(this.y+this.height-l)/(v.y-l)),{sx:V(e,i,r,s),sy:V(o,h,u,a)}},maxRectUniformScaleToFit:function(t,n){var e=this.maxRectScaleToFit(t,n);return V(e.sx,e.sy)},moveAndExpand:function(t){return this.x+=t.x||0,this.y+=t.y||0,this.width+=t.width||0,this.height+=t.height||0,this},normalize:function(){var t=this.x,n=this.y,e=this.width,i=this.height;return this.width<0&&(t=this.x+this.width,e=-this.width),this.height<0&&(n=this.y+this.height,i=-this.height),this.x=t,this.y=n,this.width=e,this.height=i,this},offset:function(t,n){return E.prototype.offset.call(this,t,n)},origin:function(){return new E(this.x,this.y)},pointNearestToPoint:function(t){if(t=new E(t),this.containsPoint(t))switch(this.sideNearestToPoint(t)){case"right":return new E(this.x+this.width,t.y);case"left":return new E(this.x,t.y);case"bottom":return new E(t.x,this.y+this.height);case"top":return new E(t.x,this.y)}return t.adhereToRect(this)},rightLine:function(){return new R(this.topRight(),this.bottomRight())},rightMiddle:function(){return new E(this.x+this.width,this.y+this.height/2)},round:function(t){var n=1;if(t)switch(t){case 1:n=10;break;case 2:n=100;break;case 3:n=1e3;break;default:n=B(10,t)}return this.x=Z(this.x*n)/n,this.y=Z(this.y*n)/n,this.width=Z(this.width*n)/n,this.height=Z(this.height*n)/n,this},scale:function(t,n,e){return e=this.origin().scale(t,n,e),this.x=e.x,this.y=e.y,this.width*=t,this.height*=n,this},sideNearestToPoint:function(t){var n=(t=new E(t)).x-this.x,e=this.x+this.width-t.x,i=t.y-this.y,r=n,s="left";return e<r&&(r=e,s="right"),i<r&&(r=i,s="top"),this.y+this.height-t.y<r&&(s="bottom"),s},snapToGrid:function(t,n){var e=this.origin().snapToGrid(t,n),i=this.corner().snapToGrid(t,n);return this.x=e.x,this.y=e.y,this.width=i.x-e.x,this.height=i.y-e.y,this},toJSON:function(){return{x:this.x,y:this.y,width:this.width,height:this.height}},topLine:function(){return new R(this.topLeft(),this.topRight())},topMiddle:function(){return new E(this.x+this.width/2,this.y)},topRight:function(){return new E(this.x+this.width,this.y)},toString:function(){return this.origin().toString()+" "+this.corner().toString()},union:function(t){return G.fromRectUnion(this,t)},update:function(t,n,e,i){return Object(t)===t&&(n=t.y,e=t.width,i=t.height,t=t.x),this.x=t||0,this.y=n||0,this.width=e||0,this.height=i||0,this}},G.prototype.bottomRight=G.prototype.corner,G.prototype.topLeft=G.prototype.origin,G.prototype.translate=G.prototype.offset;var U=G;function X(t){var n=t.trim();if(""===n)return[];for(var e=[],i=n.split(/\b\s*,\s*|,\s*|\s+/),r=i.length,s=0;s<r;s+=2)e.push({x:+i[s],y:+i[s+1]});return e}function Y(t){var n=t.length;if(0===n)return[];for(var e=[],i=0;i<n;i++){var r=t[i].clone();e.push(r)}return e}function H(t){var n,e,i,r=Math.abs,s=t.length;if(0===s)return[];for(n=0;n<s;n++)void 0===i?i=t[n]:t[n].y<i.y?i=t[n]:t[n].y===i.y&&t[n].x>i.x&&(i=t[n]);var o=[];for(n=0;n<s;n++){var h=i.theta(t[n]);0===h&&(h=360);var u=[t[n],n,h];o.push(u)}if(o.sort(function(t,n){var e=t[2]-n[2];return 0===e&&(e=n[1]-t[1]),e}),2<o.length){var a=o[o.length-1];o.unshift(a)}for(var c,l,f,d,g,v,p,y={},w=[];0!==o.length;)if(l=(c=o.pop())[0],!y.hasOwnProperty(c[0]+"@@"+c[1]))for(var m=!1;!m;)if(w.length<2)w.push(c),m=!0;else{d=(f=w.pop())[0];var x=(v=(g=w.pop())[0]).cross(d,l);if(x<0)w.push(g),w.push(f),w.push(c),m=!0;else if(0===x){var b=d.angleBetween(v,l);r(b-180)<1e-10?(y[f[0]+"@@"+f[1]]=d,w.push(g)):d.equals(l)||v.equals(d)?(y[f[0]+"@@"+f[1]]=d,w.push(g)):r((b+1)%360-1)<1e-10&&(w.push(g),o.push(f))}else y[f[0]+"@@"+f[1]]=d,w.push(g)}2<w.length&&w.pop();var S=-1;for(e=w.length,n=0;n<e;n++){var P=w[n][1];(void 0===p||P<p)&&(p=P,S=n)}var A=[];if(0<S){var L=w.slice(S),E=w.slice(0,S);A=L.concat(E)}else A=w;var T=[];for(e=A.length,n=0;n<e;n++)T.push(A[n][0]);return T}var J=function(t){return this instanceof J?"string"==typeof t?new J.parse(t):void(this.points=Array.isArray(t)?t.map(E):[]):new J(t)};J.parse=function(t){return new J(X(t))},J.fromRect=function(t){return new J([t.topLeft(),t.topRight(),t.bottomRight(),t.bottomLeft(),t.topLeft()])},J.prototype={type:v.Polyline,bbox:function(){var t=1/0,n=-1/0,e=1/0,i=-1/0,r=this.points,s=r.length;if(0===s)return null;for(var o=0;o<s;o++){var h=r[o],u=h.x,a=h.y;u<t&&(t=u),n<u&&(n=u),a<e&&(e=a),i<a&&(i=a)}return new G(t,e,n-t,i-e)},clone:function(){return new J(Y(this.points))},closestPoint:function(t){var n=this.closestPointLength(t);return this.pointAtLength(n)},closestPointLength:function(t){var n,e=this.lengthPoints(),i=e.length;if(0===i)return 0;if(1===i)return 0;for(var r=1/0,s=0,o=i-1,h=0;h<o;h++){var u=new R(e[h],e[h+1]),a=u.length(),c=u.closestPointNormalizedLength(t),l=u.pointAt(c).squaredDistance(t);l<r&&(r=l,n=s+c*a),s+=a}return n},closestPointNormalizedLength:function(t){var n=this.closestPointLength(t);if(0===n)return 0;var e=this.length();return 0===e?0:n/e},closestPointTangent:function(t){var n=this.closestPointLength(t);return this.tangentAtLength(n)},containsPoint:function(t){var n=this.points,e=n.length;if(0===e)return!1;for(var i=t.x,r=t.y,s=e-1,o=0,h=0,u=new R,a=new R,c=new E;o<e;o++){var l=n[s],f=n[o];if(t.equals(l))return!0;if(u.start=l,u.end=f,u.containsPoint(t))return!0;if(r<=l.y&&r>f.y||r>l.y&&r<=f.y){var d=l.x-i>f.x-i?l.x-i:f.x-i;0<=d&&(c.x=i+d,c.y=r,a.start=t,a.end=c,u.intersect(a)&&h++)}s=o}return h%2==1},close:function(){var t=this.start,n=this.end,e=this.points;return t&&n&&!t.equals(n)&&e.push(t.clone()),this},lengthPoints:function(){return this.points},convexHull:function(){return new J(H(this.points))},equals:function(t){if(!t)return!1;var n=this.points,e=t.points,i=n.length;if(e.length!==i)return!1;for(var r=0;r<i;r++){var s=n[r],o=t.points[r];if(!s.equals(o))return!1}return!0},intersectionWithLine:function(t){for(var n=new R(t),e=[],i=this.lengthPoints(),r=new R,s=0,o=i.length-1;s<o;s++){r.start=i[s],r.end=i[s+1];var h=n.intersectionWithLine(r);h&&e.push(h[0])}return 0<e.length?e:null},isDifferentiable:function(){var t=this.points,n=t.length;if(0===n)return!1;for(var e=new R,i=n-1,r=0;r<i;r++)if(e.start=t[r],e.end=t[r+1],e.isDifferentiable())return!0;return!1},length:function(){var t=this.lengthPoints(),n=t.length;if(0===n)return 0;for(var e=0,i=n-1,r=0;r<i;r++)e+=t[r].distance(t[r+1]);return e},pointAt:function(t){var n=this.lengthPoints(),e=n.length;if(0===e)return null;if(1===e)return n[0].clone();if(t<=0)return n[0].clone();if(1<=t)return n[e-1].clone();var i=this.length()*t;return this.pointAtLength(i)},pointAtLength:function(t){var n=this.lengthPoints(),e=n.length;if(0===e)return null;if(1===e)return n[0].clone();var i=!0;t<0&&(i=!1,t=-t);for(var r=0,s=e-1,o=0;o<s;o++){var h=i?o:s-1-o,u=n[h],a=n[h+1],c=new R(u,a),l=u.distance(a);if(t<=r+l)return c.pointAtLength((i?1:-1)*(t-r));r+=l}return(i?n[e-1]:n[0]).clone()},round:function(t){for(var n=this.points,e=n.length,i=0;i<e;i++)n[i].round(t);return this},scale:function(t,n,e){for(var i=this.points,r=i.length,s=0;s<r;s++)i[s].scale(t,n,e);return this},simplify:function(t){void 0===t&&(t={});var n=this.points;if(n.length<3)return this;for(var e=t.threshold||0,i=0;n[i+2];){var r=i+1,s=i+2,o=n[i],h=n[r],u=n[s];new R(o,u).closestPoint(h).distance(h)<=e?n.splice(r,1):i+=1}return this},tangentAt:function(t){var n=this.lengthPoints().length;if(0===n)return null;if(1===n)return null;t<0&&(t=0),1<t&&(t=1);var e=this.length()*t;return this.tangentAtLength(e)},tangentAtLength:function(t){var n=this.lengthPoints(),e=n.length;if(0===e)return null;if(1===e)return null;var i,r=!0;t<0&&(r=!1,t=-t);for(var s=0,o=e-1,h=0;h<o;h++){var u=r?h:o-1-h,a=n[u],c=n[u+1],l=new R(a,c),f=a.distance(c);if(l.isDifferentiable()){if(t<=s+f)return l.tangentAtLength((r?1:-1)*(t-s));i=l}s+=f}if(i){var d=r?1:0;return i.tangentAt(d)}return null},toString:function(){return this.points+""},translate:function(t,n){for(var e=this.points,i=e.length,r=0;r<i;r++)e[r].translate(t,n);return this},serialize:function(){var t=this.points,n=t.length;if(0===n)return"";for(var e="",i=0;i<n;i++){var r=t[i];e+=r.x+","+r.y+" "}return e.trim()}},Object.defineProperty(J.prototype,"start",{configurable:!0,enumerable:!0,get:function(){return 0===this.points.length?null:this.points[0]}}),Object.defineProperty(J.prototype,"end",{configurable:!0,enumerable:!0,get:function(){var t=this.points.length;return 0===t?null:this.points[t-1]}});var _=Math.abs,$=Math.sqrt,K=Math.min,Q=Math.max,tt=Math.pow,nt=function(t,n,e,i){return this instanceof nt?t instanceof nt?new nt(t.start,t.controlPoint1,t.controlPoint2,t.end):(this.start=new E(t),this.controlPoint1=new E(n),this.controlPoint2=new E(e),void(this.end=new E(i))):new nt(t,n,e,i)};function et(t){var n,e,i=arguments,r=[];for(e=arguments.length,n=1;n<e;n++)r.push(i[n]);if(!t)throw new Error("Missing a parent object.");var s=Object.create(t);for(e=r.length,n=0;n<e;n++){var o,h,u=r[n];for(h in u)u.hasOwnProperty(h)&&(delete s[h],o=Object.getOwnPropertyDescriptor(u,h),Object.defineProperty(s,h,o))}return s}nt.throughPoints=function(){function u(t){var n=t.length,e=[],i=[],r=2;e[0]=t[0]/r;for(var s=1;s<n;s++)i[s]=1/r,r=(s<n-1?4:3.5)-i[s],e[s]=(t[s]-e[s-1])/r;for(s=1;s<n;s++)e[n-s-1]-=i[n-s]*e[n-s];return e}return function(t){if(!t||Array.isArray(t)&&t.length<2)throw new Error("At least 2 points are required");for(var n=function(t){var n,e=[],i=[],r=t.length-1;if(1==r)return e[0]=new E((2*t[0].x+t[1].x)/3,(2*t[0].y+t[1].y)/3),i[0]=new E(2*e[0].x-t[0].x,2*e[0].y-t[0].y),[e,i];var s=[];for(n=1;n<r-1;n++)s[n]=4*t[n].x+2*t[n+1].x;s[0]=t[0].x+2*t[1].x,s[r-1]=(8*t[r-1].x+t[r].x)/2;var o=u(s);for(n=1;n<r-1;++n)s[n]=4*t[n].y+2*t[n+1].y;s[0]=t[0].y+2*t[1].y,s[r-1]=(8*t[r-1].y+t[r].y)/2;var h=u(s);for(n=0;n<r;n++)e.push(new E(o[n],h[n])),n<r-1?i.push(new E(2*t[n+1].x-o[n+1],2*t[n+1].y-h[n+1])):i.push(new E((t[r].x+o[r-1])/2,(t[r].y+h[r-1])/2));return[e,i]}(t),e=[],i=n[0].length,r=0;r<i;r++){var s=new E(n[0][r].x,n[0][r].y),o=new E(n[1][r].x,n[1][r].y);e.push(new nt(t[r],s,o,t[r+1]))}return e}}(),nt.prototype={type:v.Curve,bbox:function(){for(var t,n,e,i,r,s,o,h,u=this.start,a=this.controlPoint1,c=this.controlPoint2,l=this.end,f=u.x,d=u.y,g=a.x,v=a.y,p=c.x,y=c.y,w=l.x,m=l.y,x=new Array,b=new Array,S=[new Array,new Array],P=0;P<2;++P)if(e=0===P?(n=6*f-12*g+6*p,t=-3*f+9*g-9*p+3*w,3*g-3*f):(n=6*d-12*v+6*y,t=-3*d+9*v-9*y+3*m,3*v-3*d),_(t)<1e-12){if(_(n)<1e-12)continue;0<(i=-e/n)&&i<1&&b.push(i)}else h=$(o=n*n-4*e*t),o<0||(0<(r=(-n+h)/(2*t))&&r<1&&b.push(r),0<(s=(-n-h)/(2*t))&&s<1&&b.push(s));for(var A,L,E,T=b.length,I=T;T--;)L=(A=1-(i=b[T]))*A*A*f+3*A*A*i*g+3*A*i*i*p+i*i*i*w,S[0][T]=L,E=A*A*A*d+3*A*A*i*v+3*A*i*i*y+i*i*i*m,S[1][T]=E,x[T]={X:L,Y:E};b[I]=0,b[I+1]=1,x[I]={X:f,Y:d},x[I+1]={X:w,Y:m},S[0][I]=f,S[1][I]=d,S[0][I+1]=w,S[1][I+1]=m,b.length=I+2,S[0].length=I+2,S[1].length=I+2,x.length=I+2;var C=K.apply(null,S[0]),R=K.apply(null,S[1]),D=Q.apply(null,S[0]),M=Q.apply(null,S[1]);return new G(C,R,D-C,M-R)},clone:function(){return new nt(this.start,this.controlPoint1,this.controlPoint2,this.end)},closestPoint:function(t,n){return this.pointAtT(this.closestPointT(t,n))},closestPointLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions};return this.lengthAtT(this.closestPointT(t,i),i)},closestPointNormalizedLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions},r=this.closestPointLength(t,i);if(!r)return 0;var s=this.length(i);return 0===s?0:r/s},closestPointT:function(t,n){for(var e,i,r,s,o,h,u,a=void 0===(n=n||{}).precision?this.PRECISION:n.precision,c=void 0===n.subdivisions?this.getSubdivisions({precision:a}):n.subdivisions,l=c.length,f=l?1/l:0,d=0;d<l;d++){var g=c[d],v=g.start.distance(t),p=g.end.distance(t),y=v+p;(!u||y<u)&&(i=d*f,r=(d+1)*f,s=v,o=p,h=(e=g).start.distance(g.end),u=y)}for(var w=tt(10,-a);;){var m=s?_(s-o)/s:0,x=o?_(s-o)/o:0;if(m<w||x<w||(!s||s<h*w||(!o||o<h*w)))return s<=o?i:r;var b=e.divide(.5);f/=2;var S=b[0].start.distance(t),P=b[0].end.distance(t),A=S+P,L=b[1].start.distance(t),E=b[1].end.distance(t);o=A<=L+E?(e=b[0],r-=f,s=S,P):(e=b[1],i+=f,s=L,E)}},closestPointTangent:function(t,n){return this.tangentAtT(this.closestPointT(t,n))},containsPoint:function(t,n){return this.toPolyline(n).containsPoint(t)},divideAt:function(t,n){if(t<=0)return this.divideAtT(0);if(1<=t)return this.divideAtT(1);var e=this.tAt(t,n);return this.divideAtT(e)},divideAtLength:function(t,n){var e=this.tAtLength(t,n);return this.divideAtT(e)},divideAtT:function(t){var n=this.start,e=this.controlPoint1,i=this.controlPoint2,r=this.end;if(t<=0)return[new nt(n,n,n,n),new nt(n,e,i,r)];if(1<=t)return[new nt(n,e,i,r),new nt(r,r,r,r)];var s=this.getSkeletonPoints(t),o=s.startControlPoint1,h=s.startControlPoint2,u=s.divider,a=s.dividerControlPoint1,c=s.dividerControlPoint2;return[new nt(n,o,h,u),new nt(u,a,c,r)]},endpointDistance:function(){return this.start.distance(this.end)},equals:function(t){return!!t&&this.start.x===t.start.x&&this.start.y===t.start.y&&this.controlPoint1.x===t.controlPoint1.x&&this.controlPoint1.y===t.controlPoint1.y&&this.controlPoint2.x===t.controlPoint2.x&&this.controlPoint2.y===t.controlPoint2.y&&this.end.x===t.end.x&&this.end.y===t.end.y},getSkeletonPoints:function(t){var n=this.start,e=this.controlPoint1,i=this.controlPoint2,r=this.end;if(t<=0)return{startControlPoint1:n.clone(),startControlPoint2:n.clone(),divider:n.clone(),dividerControlPoint1:e.clone(),dividerControlPoint2:i.clone()};if(1<=t)return{startControlPoint1:e.clone(),startControlPoint2:i.clone(),divider:r.clone(),dividerControlPoint1:r.clone(),dividerControlPoint2:r.clone()};var s=new R(n,e).pointAt(t),o=new R(e,i).pointAt(t),h=new R(i,r).pointAt(t),u=new R(s,o).pointAt(t),a=new R(o,h).pointAt(t);return{startControlPoint1:s,startControlPoint2:u,divider:new R(u,a).pointAt(t),dividerControlPoint1:a,dividerControlPoint2:h}},getSubdivisions:function(t){var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=this.start,i=this.controlPoint1,r=this.controlPoint2,s=this.end,o=[new nt(e,i,r,s)];if(0===n)return o;if(!this.isDifferentiable())return o;var h=this.endpointDistance(),u=tt(10,-n),a=2;0===i.cross(e,s)&&0===r.cross(e,s)&&(a=2*n);for(var c=0;;){c+=1;for(var l=[],f=o.length,d=0;d<f;d++){var g=o[d].divide(.5);l.push(g[0],g[1])}for(var v=0,p=l.length,y=0;y<p;y++){v+=l[y].endpointDistance()}if(a<=c)if((0!==v?(v-h)/v:0)<u)return l;o=l,h=v}},isDifferentiable:function(){var t=this.start,n=this.controlPoint1,e=this.controlPoint2,i=this.end;return!(t.equals(n)&&n.equals(e)&&e.equals(i))},length:function(t){for(var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=void 0===t.subdivisions?this.getSubdivisions({precision:n}):t.subdivisions,i=0,r=e.length,s=0;s<r;s++){i+=e[s].endpointDistance()}return i},lengthAtT:function(t,n){if(t<=0)return 0;var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision;return this.divide(t)[0].length({precision:e})},pointAt:function(t,n){if(t<=0)return this.start.clone();if(1<=t)return this.end.clone();var e=this.tAt(t,n);return this.pointAtT(e)},pointAtLength:function(t,n){var e=this.tAtLength(t,n);return this.pointAtT(e)},pointAtT:function(t){return t<=0?this.start.clone():1<=t?this.end.clone():this.getSkeletonPoints(t).divider},PRECISION:3,round:function(t){return this.start.round(t),this.controlPoint1.round(t),this.controlPoint2.round(t),this.end.round(t),this},scale:function(t,n,e){return this.start.scale(t,n,e),this.controlPoint1.scale(t,n,e),this.controlPoint2.scale(t,n,e),this.end.scale(t,n,e),this},tangentAt:function(t,n){if(!this.isDifferentiable())return null;t<0?t=0:1<t&&(t=1);var e=this.tAt(t,n);return this.tangentAtT(e)},tangentAtLength:function(t,n){if(!this.isDifferentiable())return null;var e=this.tAtLength(t,n);return this.tangentAtT(e)},tangentAtT:function(t){if(!this.isDifferentiable())return null;t<0?t=0:1<t&&(t=1);var n=this.getSkeletonPoints(t),e=n.startControlPoint2,i=n.dividerControlPoint1,r=n.divider,s=new R(e,i);return s.translate(r.x-e.x,r.y-e.y),s},tAt:function(t,n){if(t<=0)return 0;if(1<=t)return 1;var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,subdivisions:void 0===n.subdivisions?this.getSubdivisions({precision:e}):n.subdivisions},r=this.length(i)*t;return this.tAtLength(r,i)},tAtLength:function(t,n){var e=!0;t<0&&(e=!1,t=-t);for(var i,r,s,o,h,u=void 0===(n=n||{}).precision?this.PRECISION:n.precision,a=void 0===n.subdivisions?this.getSubdivisions({precision:u}):n.subdivisions,c={precision:u,subdivisions:a},l=0,f=a.length,d=1/f,g=0;g<f;g++){var v=e?g:f-1-g,p=a[g],y=p.endpointDistance();if(t<=l+y){i=p,r=v*d,s=(v+1)*d,o=e?t-l:y+l-t,h=e?y+l-t:t-l;break}l+=y}if(!i)return e?1:0;for(var w=this.length(c),m=tt(10,-u);;){var x,b;if((0!==w?o/w:0)<m)return r;if((0!==w?h/w:0)<m)return s;var S=i.divide(.5);d/=2;var P=S[0].endpointDistance(),A=S[1].endpointDistance();b=o<=P?(i=S[0],s-=d,P-(x=o)):(i=S[1],r+=d,A-(x=o-P)),o=x,h=b}},toPoints:function(t){for(var n=void 0===(t=t||{}).precision?this.PRECISION:t.precision,e=void 0===t.subdivisions?this.getSubdivisions({precision:n}):t.subdivisions,i=[e[0].start.clone()],r=e.length,s=0;s<r;s++){var o=e[s];i.push(o.end.clone())}return i},toPolyline:function(t){return new J(this.toPoints(t))},toString:function(){return this.start+" "+this.controlPoint1+" "+this.controlPoint2+" "+this.end},translate:function(t,n){return this.start.translate(t,n),this.controlPoint1.translate(t,n),this.controlPoint2.translate(t,n),this.end.translate(t,n),this}},nt.prototype.divide=nt.prototype.divideAtT;var it=function(t){if(!(this instanceof it))return new it(t);if("string"==typeof t)return new it.parse(t);var n,e;if(this.segments=[],t)if(Array.isArray(t)&&0!==t.length)if(e=(t=t.reduce(function(t,n){return t.concat(n)},[])).length,t[0].isSegment)for(n=0;n<e;n++){var i=t[n];this.appendSegment(i)}else{var r=null;for(n=0;n<e;n++){var s=t[n];if(!(s instanceof R||s instanceof nt))throw new Error("Cannot construct a path segment from the provided object.");0===n&&this.appendSegment(it.createSegment("M",s.start)),r&&!r.end.equals(s.start)&&this.appendSegment(it.createSegment("M",s.start)),s instanceof R?this.appendSegment(it.createSegment("L",s.end)):s instanceof nt&&this.appendSegment(it.createSegment("C",s.controlPoint1,s.controlPoint2,s.end)),r=s}}else if(t.isSegment)this.appendSegment(t);else if(t instanceof R)this.appendSegment(it.createSegment("M",t.start)),this.appendSegment(it.createSegment("L",t.end));else if(t instanceof nt)this.appendSegment(it.createSegment("M",t.start)),this.appendSegment(it.createSegment("C",t.controlPoint1,t.controlPoint2,t.end));else{if(!(t instanceof J))throw new Error("Cannot construct a path from the provided object.");if(!t.points||0===t.points.length)return;for(e=t.points.length,n=0;n<e;n++){var o=t.points[n];0===n?this.appendSegment(it.createSegment("M",o)):this.appendSegment(it.createSegment("L",o))}}else;};function rt(t,n){return n.unshift(null),new(Function.prototype.bind.apply(t,n))}it.parse=function(t){if(!t)return new it;for(var n=new it,e=t.match(/(?:[a-zA-Z] *)(?:(?:-?\d+(?:\.\d+)?(?:e[-+]?\d+)? *,? *)|(?:-?\.\d+ *,? *))+|(?:[a-zA-Z] *)(?! |\d|-|\.)/g),i=e.length,r=0;r<i;r++){var s=e[r].match(/(?:[a-zA-Z])|(?:(?:-?\d+(?:\.\d+)?(?:e[-+]?\d+)?))|(?:(?:-?\.\d+))/g),o=it.createSegment.apply(this,s);n.appendSegment(o)}return n},it.createSegment=function(t){var n=arguments;if(!t)throw new Error("Type must be provided.");var e=it.segmentTypes[t];if(!e)throw new Error(t+" is not a recognized path segment type.");for(var i=[],r=arguments.length,s=1;s<r;s++)i.push(n[s]);return rt(e,i)},it.prototype={type:v.Path,appendSegment:function(t){var n,e=this.segments,i=e.length,r=0!==i?e[i-1]:null;if(Array.isArray(t)){if(!(t=t.reduce(function(t,n){return t.concat(n)},[]))[0].isSegment)throw new Error("Segments required.");for(var s=t.length,o=0;o<s;o++){var h=t[o];n=this.prepareSegment(h,r,null),e.push(n),r=n}}else{if(!t||!t.isSegment)throw new Error("Segment required.");n=this.prepareSegment(t,r,null),e.push(n)}},bbox:function(){var t,n=this.segments,e=n.length;if(0===e)return null;for(var i=0;i<e;i++){var r=n[i];if(r.isVisible){var s=r.bbox();t=t?t.union(s):s}}if(t)return t;var o=n[e-1];return new G(o.end.x,o.end.y,0,0)},clone:function(){for(var t=this.segments,n=t.length,e=new it,i=0;i<n;i++){var r=t[i].clone();e.appendSegment(r)}return e},closestPoint:function(t,n){var e=this.closestPointT(t,n);return e?this.pointAtT(e):null},closestPointLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.closestPointT(t,i);return r?this.lengthAtT(r,i):0},closestPointNormalizedLength:function(t,n){var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.closestPointLength(t,i);if(0===r)return 0;var s=this.length(i);return 0===s?0:r/s},closestPointT:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;for(var r,s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,h=1/0,u=0;u<i;u++){var a=e[u],c=o[u];if(a.isVisible){var l=a.closestPointT(t,{precision:s,subdivisions:c}),f=a.pointAtT(l),d=new R(f,t).squaredLength();d<h&&(r={segmentIndex:u,value:l},h=d)}}return r||{segmentIndex:i-1,value:1}},closestPointTangent:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;for(var r,s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,h=1/0,u=0;u<i;u++){var a=e[u],c=o[u];if(a.isDifferentiable()){var l=a.closestPointT(t,{precision:s,subdivisions:c}),f=a.pointAtT(l),d=new R(f,t).squaredLength();d<h&&(r=a.tangentAtT(l),h=d)}}return r||null},containsPoint:function(t,n){var e=this.toPolylines(n);if(!e)return!1;for(var i=e.length,r=0,s=0;s<i;s++){e[s].containsPoint(t)&&r++}return r%2==1},divideAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.divideAtLength(r,i)},divideAtLength:function(t,n){var e=this.segments.length;if(0===e)return null;var i=!0;t<0&&(i=!1,t=-t);var r,s,o,h,u,a,c,l=void 0===(n=n||{}).precision?this.PRECISION:n.precision,f=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:l}):n.segmentSubdivisions,d=0;for(r=0;r<e;r++){var g=i?r:e-1-r;s=this.getSegment(g);var v=f[g],p=s.length({precision:l,subdivisions:v});if(s.isDifferentiable()&&(u=s,a=g,t<=d+p)){h=g,o=s.divideAtLength((i?1:-1)*(t-d),{precision:l,subdivisions:v});break}d+=p}if(!u)return null;o||(h=a,c=i?1:0,o=u.divideAtT(c));var y=this.clone();y.replaceSegment(h,o);var w=h,m=h+1,x=h+2;o[0].isDifferentiable()||(y.removeSegment(w),m-=1,x-=1);var b=y.getSegment(m).start;y.insertSegment(m,it.createSegment("M",b)),x+=1,o[1].isDifferentiable()||(y.removeSegment(x-1),x-=1);var S=x-w-1;for(r=x;r<y.segments.length;r++){var P=this.getSegment(r-S);if("Z"===(s=y.getSegment(r)).type&&!P.subpathStartSegment.end.equals(s.subpathStartSegment.end)){var A=it.createSegment("L",P.end);y.replaceSegment(r,A)}}return[new it(y.segments.slice(0,m)),new it(y.segments.slice(m))]},equals:function(t){if(!t)return!1;var n=this.segments,e=t.segments,i=n.length;if(e.length!==i)return!1;for(var r=0;r<i;r++){var s=n[r],o=e[r];if(s.type!==o.type||!s.equals(o))return!1}return!0},getSegment:function(t){var n=this.segments,e=n.length;if(0===e)throw new Error("Path has no segments.");if(t<0&&(t=e+t),e<=t||t<0)throw new Error("Index out of range.");return n[t]},getSegmentSubdivisions:function(t){for(var n=this.segments,e=n.length,i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=[],s=0;s<e;s++){var o=n[s].getSubdivisions({precision:i});r.push(o)}return r},getSubpaths:function(){for(var t=this.clone().validate().segments,n=t.length,e=[],i=0;i<n;i++){var r=t[i];r.isSubpathStart?e.push(new it(r)):e[e.length-1].appendSegment(r)}return e},insertSegment:function(t,n){var e,i=this.segments,r=i.length;if(t<0&&(t=r+t+1),r<t||t<0)throw new Error("Index out of range.");var s=null,o=null;if(0!==r&&(o=1<=t?(s=i[t-1]).nextSegment:i[0]),Array.isArray(n)){if(!(n=n.reduce(function(t,n){return t.concat(n)},[]))[0].isSegment)throw new Error("Segments required.");for(var h=n.length,u=0;u<h;u++){var a=n[u];e=this.prepareSegment(a,s,o),i.splice(t+u,0,e),s=e}}else{if(!n||!n.isSegment)throw new Error("Segment required.");e=this.prepareSegment(n,s,o),i.splice(t,0,e)}},intersectionWithLine:function(t,n){var e=null,i=this.toPolylines(n);if(!i)return null;for(var r=0,s=i.length;r<s;r++){var o=i[r],h=t.intersect(o);h&&(e||(e=[]),Array.isArray(h)?Array.prototype.push.apply(e,h):e.push(h))}return e},isDifferentiable:function(){for(var t=this.segments,n=t.length,e=0;e<n;e++){if(t[e].isDifferentiable())return!0}return!1},isValid:function(){var t=this.segments;return 0===t.length||"M"===t[0].type},length:function(t){var n=this.segments,e=n.length;if(0===e)return 0;for(var i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=void 0===t.segmentSubdivisions?this.getSegmentSubdivisions({precision:i}):t.segmentSubdivisions,s=0,o=0;o<e;o++){var h=n[o],u=r[o];s+=h.length({subdivisions:u})}return s},lengthAtT:function(t,n){var e=this.segments,i=e.length;if(0===i)return 0;var r=t.segmentIndex;if(r<0)return 0;var s=t.value;i<=r?(r=i-1,s=1):s<0?s=0:1<s&&(s=1);for(var o,h=void 0===(n=n||{}).precision?this.PRECISION:n.precision,u=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:h}):n.segmentSubdivisions,a=0,c=0;c<r;c++){var l=e[c];o=u[c],a+=l.length({precisison:h,subdivisions:o})}return l=e[r],o=u[r],a+=l.lengthAtT(s,{precisison:h,subdivisions:o})},pointAt:function(t,n){if(0===this.segments.length)return null;if(t<=0)return this.start.clone();if(1<=t)return this.end.clone();var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.pointAtLength(r,i)},pointAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;if(0===t)return this.start.clone();var r=!0;t<0&&(r=!1,t=-t);for(var s,o=void 0===(n=n||{}).precision?this.PRECISION:n.precision,h=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:o}):n.segmentSubdivisions,u=0,a=0;a<i;a++){var c=r?a:i-1-a,l=e[c],f=h[c],d=l.length({precision:o,subdivisions:f});if(l.isVisible){if(t<=u+d)return l.pointAtLength((r?1:-1)*(t-u),{precision:o,subdivisions:f});s=l}u+=d}return s?r?s.end:s.start:e[i-1].end.clone()},pointAtT:function(t){var n=this.segments,e=n.length;if(0===e)return null;var i=t.segmentIndex;if(i<0)return n[0].pointAtT(0);if(e<=i)return n[e-1].pointAtT(1);var r=t.value;return r<0?r=0:1<r&&(r=1),n[i].pointAtT(r)},PRECISION:3,prepareSegment:function(t,n,e){t.previousSegment=n,t.nextSegment=e,n&&(n.nextSegment=t),e&&(e.previousSegment=t);var i=t;return t.isSubpathStart&&(t.subpathStartSegment=t,i=e),i&&this.updateSubpathStartSegment(i),t},removeSegment:function(t){var n=this.segments,e=n.length;if(0===e)throw new Error("Path has no segments.");if(t<0&&(t=e+t),e<=t||t<0)throw new Error("Index out of range.");var i=n.splice(t,1)[0],r=i.previousSegment,s=i.nextSegment;r&&(r.nextSegment=s),s&&(s.previousSegment=r),i.isSubpathStart&&s&&this.updateSubpathStartSegment(s)},replaceSegment:function(t,n){var e,i=this.segments,r=i.length;if(0===r)throw new Error("Path has no segments.");if(t<0&&(t=r+t),r<=t||t<0)throw new Error("Index out of range.");var s=i[t],o=s.previousSegment,h=s.nextSegment,u=s.isSubpathStart;if(Array.isArray(n)){if(!(n=n.reduce(function(t,n){return t.concat(n)},[]))[0].isSegment)throw new Error("Segments required.");i.splice(t,1);for(var a=n.length,c=0;c<a;c++){var l=n[c];e=this.prepareSegment(l,o,h),i.splice(t+c,0,e),o=e,u&&e.isSubpathStart&&(u=!1)}}else{if(!n||!n.isSegment)throw new Error("Segment required.");e=this.prepareSegment(n,o,h),i.splice(t,1,e),u&&e.isSubpathStart&&(u=!1)}u&&h&&this.updateSubpathStartSegment(h)},round:function(t){for(var n=this.segments,e=n.length,i=0;i<e;i++){n[i].round(t)}return this},scale:function(t,n,e){for(var i=this.segments,r=i.length,s=0;s<r;s++){i[s].scale(t,n,e)}return this},segmentAt:function(t,n){var e=this.segmentIndexAt(t,n);return e?this.getSegment(e):null},segmentAtLength:function(t,n){var e=this.segmentIndexAtLength(t,n);return e?this.getSegment(e):null},segmentIndexAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.segmentIndexAtLength(r,i)},segmentIndexAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;var r=!0;t<0&&(r=!1,t=-t);for(var s=void 0===(n=n||{}).precision?this.PRECISION:n.precision,o=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:s}):n.segmentSubdivisions,h=null,u=0,a=0;a<i;a++){var c=r?a:i-1-a,l=e[c],f=o[c],d=l.length({precision:s,subdivisions:f});if(l.isVisible){if(t<=u+d)return c;h=c}u+=d}return h},serialize:function(){if(!this.isValid())throw new Error("Invalid path segments.");return this.toString()},tangentAt:function(t,n){if(0===this.segments.length)return null;t<0&&(t=0),1<t&&(t=1);var e=void 0===(n=n||{}).precision?this.PRECISION:n.precision,i={precision:e,segmentSubdivisions:void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:e}):n.segmentSubdivisions},r=this.length(i)*t;return this.tangentAtLength(r,i)},tangentAtLength:function(t,n){var e=this.segments,i=e.length;if(0===i)return null;var r=!0;t<0&&(r=!1,t=-t);for(var s,o=void 0===(n=n||{}).precision?this.PRECISION:n.precision,h=void 0===n.segmentSubdivisions?this.getSegmentSubdivisions({precision:o}):n.segmentSubdivisions,u=0,a=0;a<i;a++){var c=r?a:i-1-a,l=e[c],f=h[c],d=l.length({precision:o,subdivisions:f});if(l.isDifferentiable()){if(t<=u+d)return l.tangentAtLength((r?1:-1)*(t-u),{precision:o,subdivisions:f});s=l}u+=d}if(s){var g=r?1:0;return s.tangentAtT(g)}return null},tangentAtT:function(t){var n=this.segments,e=n.length;if(0===e)return null;var i=t.segmentIndex;if(i<0)return n[0].tangentAtT(0);if(e<=i)return n[e-1].tangentAtT(1);var r=t.value;return r<0?r=0:1<r&&(r=1),n[i].tangentAtT(r)},toPoints:function(t){var n=this.segments,e=n.length;if(0===e)return null;for(var i=void 0===(t=t||{}).precision?this.PRECISION:t.precision,r=void 0===t.segmentSubdivisions?this.getSegmentSubdivisions({precision:i}):t.segmentSubdivisions,s=[],o=[],h=0;h<e;h++){var u=n[h];if(u.isVisible){var a=r[h];if(0<a.length){var c=a.map(function(t){return t.start});Array.prototype.push.apply(o,c)}else o.push(u.start)}else 0<o.length&&(o.push(n[h-1].end),s.push(o),o=[])}return 0<o.length&&(o.push(this.end),s.push(o)),s},toPolylines:function(t){var n=[],e=this.toPoints(t);if(!e)return null;for(var i=0,r=e.length;i<r;i++)n.push(new J(e[i]));return n},toString:function(){for(var t=this.segments,n=t.length,e="",i=0;i<n;i++){e+=t[i].serialize()+" "}return e.trim()},translate:function(t,n){for(var e=this.segments,i=e.length,r=0;r<i;r++){e[r].translate(t,n)}return this},updateSubpathStartSegment:function(t){for(var n=t.previousSegment;t&&!t.isSubpathStart;)t.subpathStartSegment=n?n.subpathStartSegment:null,t=(n=t).nextSegment},validate:function(){return this.isValid()||this.insertSegment(0,it.createSegment("M",0,0)),this}},Object.defineProperty(it.prototype,"start",{configurable:!0,enumerable:!0,get:function(){var t=this.segments,n=t.length;if(0===n)return null;for(var e=0;e<n;e++){var i=t[e];if(i.isVisible)return i.start}return t[n-1].end}}),Object.defineProperty(it.prototype,"end",{configurable:!0,enumerable:!0,get:function(){var t=this.segments,n=t.length;if(0===n)return null;for(var e=n-1;0<=e;e--){var i=t[e];if(i.isVisible)return i.end}return t[n-1].end}});var st={bbox:function(){throw new Error("Declaration missing for virtual function.")},clone:function(){throw new Error("Declaration missing for virtual function.")},closestPoint:function(){throw new Error("Declaration missing for virtual function.")},closestPointLength:function(){throw new Error("Declaration missing for virtual function.")},closestPointNormalizedLength:function(){throw new Error("Declaration missing for virtual function.")},closestPointT:function(t){if(this.closestPointNormalizedLength)return this.closestPointNormalizedLength(t);throw new Error("Neither closestPointT() nor closestPointNormalizedLength() function is implemented.")},closestPointTangent:function(){throw new Error("Declaration missing for virtual function.")},divideAt:function(){throw new Error("Declaration missing for virtual function.")},divideAtLength:function(){throw new Error("Declaration missing for virtual function.")},divideAtT:function(t){if(this.divideAt)return this.divideAt(t);throw new Error("Neither divideAtT() nor divideAt() function is implemented.")},equals:function(){throw new Error("Declaration missing for virtual function.")},getSubdivisions:function(){throw new Error("Declaration missing for virtual function.")},isDifferentiable:function(){throw new Error("Declaration missing for virtual function.")},isSegment:!0,isSubpathStart:!1,isVisible:!0,length:function(){throw new Error("Declaration missing for virtual function.")},lengthAtT:function(t){if(t<=0)return 0;var n=this.length();return 1<=t?n:n*t},nextSegment:null,pointAt:function(){throw new Error("Declaration missing for virtual function.")},pointAtLength:function(){throw new Error("Declaration missing for virtual function.")},pointAtT:function(t){if(this.pointAt)return this.pointAt(t);throw new Error("Neither pointAtT() nor pointAt() function is implemented.")},previousSegment:null,round:function(){throw new Error("Declaration missing for virtual function.")},subpathStartSegment:null,scale:function(){throw new Error("Declaration missing for virtual function.")},serialize:function(){throw new Error("Declaration missing for virtual function.")},tangentAt:function(){throw new Error("Declaration missing for virtual function.")},tangentAtLength:function(){throw new Error("Declaration missing for virtual function.")},tangentAtT:function(t){if(this.tangentAt)return this.tangentAt(t);throw new Error("Neither tangentAtT() nor tangentAt() function is implemented.")},toString:function(){throw new Error("Declaration missing for virtual function.")},translate:function(){throw new Error("Declaration missing for virtual function.")}};Object.defineProperty(st,"end",{configurable:!0,enumerable:!0,writable:!0}),Object.defineProperty(st,"start",{configurable:!0,enumerable:!0,get:function(){if(!this.previousSegment)throw new Error("Missing previous segment. (This segment cannot be the first segment of a path; OR segment has not yet been added to a path.)");return this.previousSegment.end}}),Object.defineProperty(st,"type",{configurable:!0,enumerable:!0,get:function(){throw new Error("Bad segment declaration. No type specified.")}});var ot=function(){for(var t,n,e=arguments,i=[],r=arguments.length,s=0;s<r;s++)i.push(e[s]);if(!(this instanceof ot))return rt(ot,i);if(0===r)throw new Error("Lineto constructor expects a line, 1 point, or 2 coordinates (none provided).");if(i[0]instanceof R){if(1===r)return this.end=i[0].end.clone(),this;throw new Error("Lineto constructor expects a line, 1 point, or 2 coordinates ("+r+" lines provided).")}if("string"==typeof i[0]||"number"==typeof i[0]){if(2===r)return this.end=new E(+i[0],+i[1]),this;if(r<2)throw new Error("Lineto constructor expects a line, 1 point, or 2 coordinates ("+r+" coordinates provided).");var o;for(t=[],s=0;s<r;s+=2)o=i.slice(s,s+2),t.push(rt(ot,o));return t}if(1===r)return this.end=new E(i[0]),this;for(t=[],s=0;s<r;s+=1)n=i[s],t.push(new ot(n));return t},ht={clone:function(){return new ot(this.end)},divideAt:function(t){var n=new R(this.start,this.end).divideAt(t);return[new ot(n[0]),new ot(n[1])]},divideAtLength:function(t){var n=new R(this.start,this.end).divideAtLength(t);return[new ot(n[0]),new ot(n[1])]},getSubdivisions:function(){return[]},isDifferentiable:function(){return!!this.previousSegment&&!this.start.equals(this.end)},round:function(t){return this.end.round(t),this},scale:function(t,n,e){return this.end.scale(t,n,e),this},serialize:function(){var t=this.end;return this.type+" "+t.x+" "+t.y},toString:function(){return this.type+" "+this.start+" "+this.end},translate:function(t,n){return this.end.translate(t,n),this}};Object.defineProperty(ht,"type",{configurable:!0,enumerable:!0,value:"L"}),ot.prototype=et(st,R.prototype,ht);var ut=function(){for(var t,n,e=arguments,i=[],r=arguments.length,s=0;s<r;s++)i.push(e[s]);if(!(this instanceof ut))return rt(ut,i);if(0===r)throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates (none provided).");if(i[0]instanceof nt){if(1===r)return this.controlPoint1=i[0].controlPoint1.clone(),this.controlPoint2=i[0].controlPoint2.clone(),this.end=i[0].end.clone(),this;throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates ("+r+" curves provided).")}if("string"==typeof i[0]||"number"==typeof i[0]){if(6===r)return this.controlPoint1=new E(+i[0],+i[1]),this.controlPoint2=new E(+i[2],+i[3]),this.end=new E(+i[4],+i[5]),this;if(r<6)throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates ("+r+" coordinates provided).");var o;for(t=[],s=0;s<r;s+=6)o=i.slice(s,s+6),t.push(rt(ut,o));return t}if(3===r)return this.controlPoint1=new E(i[0]),this.controlPoint2=new E(i[1]),this.end=new E(i[2]),this;if(r<3)throw new Error("Curveto constructor expects a curve, 3 points, or 6 coordinates ("+r+" points provided).");for(t=[],s=0;s<r;s+=3)n=i.slice(s,s+3),t.push(rt(ut,n));return t},at={clone:function(){return new ut(this.controlPoint1,this.controlPoint2,this.end)},divideAt:function(t,n){var e=new nt(this.start,this.controlPoint1,this.controlPoint2,this.end).divideAt(t,n);return[new ut(e[0]),new ut(e[1])]},divideAtLength:function(t,n){var e=new nt(this.start,this.controlPoint1,this.controlPoint2,this.end).divideAtLength(t,n);return[new ut(e[0]),new ut(e[1])]},divideAtT:function(t){var n=new nt(this.start,this.controlPoint1,this.controlPoint2,this.end).divideAtT(t);return[new ut(n[0]),new ut(n[1])]},isDifferentiable:function(){if(!this.previousSegment)return!1;var t=this.start,n=this.controlPoint1,e=this.controlPoint2,i=this.end;return!(t.equals(n)&&n.equals(e)&&e.equals(i))},round:function(t){return this.controlPoint1.round(t),this.controlPoint2.round(t),this.end.round(t),this},scale:function(t,n,e){return this.controlPoint1.scale(t,n,e),this.controlPoint2.scale(t,n,e),this.end.scale(t,n,e),this},serialize:function(){var t=this.controlPoint1,n=this.controlPoint2,e=this.end;return this.type+" "+t.x+" "+t.y+" "+n.x+" "+n.y+" "+e.x+" "+e.y},toString:function(){return this.type+" "+this.start+" "+this.controlPoint1+" "+this.controlPoint2+" "+this.end},translate:function(t,n){return this.controlPoint1.translate(t,n),this.controlPoint2.translate(t,n),this.end.translate(t,n),this}};Object.defineProperty(at,"type",{configurable:!0,enumerable:!0,value:"C"}),ut.prototype=et(st,nt.prototype,at);var ct=function(){for(var t,n,e=arguments,i=[],r=arguments.length,s=0;s<r;s++)i.push(e[s]);if(!(this instanceof ct))return rt(ct,i);if(0===r)throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates (none provided).");if(i[0]instanceof R){if(1===r)return this.end=i[0].end.clone(),this;throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates ("+r+" lines provided).")}if(i[0]instanceof nt){if(1===r)return this.end=i[0].end.clone(),this;throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates ("+r+" curves provided).")}if("string"==typeof i[0]||"number"==typeof i[0]){if(2===r)return this.end=new E(+i[0],+i[1]),this;if(r<2)throw new Error("Moveto constructor expects a line, a curve, 1 point, or 2 coordinates ("+r+" coordinates provided).");var o;for(t=[],s=0;s<r;s+=2)o=i.slice(s,s+2),0===s?t.push(rt(ct,o)):t.push(rt(ot,o));return t}if(1===r)return this.end=new E(i[0]),this;for(t=[],s=0;s<r;s+=1)n=i[s],0===s?t.push(new ct(n)):t.push(new ot(n));return t},lt={bbox:function(){return null},clone:function(){return new ct(this.end)},closestPoint:function(){return this.end.clone()},closestPointNormalizedLength:function(){return 0},closestPointLength:function(){return 0},closestPointT:function(){return 1},closestPointTangent:function(){return null},divideAt:function(){return[this.clone(),this.clone()]},divideAtLength:function(){return[this.clone(),this.clone()]},equals:function(t){return this.end.equals(t.end)},getSubdivisions:function(){return[]},isDifferentiable:function(){return!1},isSubpathStart:!0,isVisible:!1,length:function(){return 0},lengthAtT:function(){return 0},pointAt:function(){return this.end.clone()},pointAtLength:function(){return this.end.clone()},pointAtT:function(){return this.end.clone()},round:function(t){return this.end.round(t),this},scale:function(t,n,e){return this.end.scale(t,n,e),this},serialize:function(){var t=this.end;return this.type+" "+t.x+" "+t.y},tangentAt:function(){return null},tangentAtLength:function(){return null},tangentAtT:function(){return null},toString:function(){return this.type+" "+this.end},translate:function(t,n){return this.end.translate(t,n),this}};Object.defineProperty(lt,"start",{configurable:!0,enumerable:!0,get:function(){throw new Error("Illegal access. Moveto segments should not need a start property.")}}),Object.defineProperty(lt,"type",{configurable:!0,enumerable:!0,value:"M"}),ct.prototype=et(st,lt);var ft=function(){for(var t=arguments,n=[],e=arguments.length,i=0;i<e;i++)n.push(t[i]);if(!(this instanceof ft))return rt(ft,n);if(0<e)throw new Error("Closepath constructor expects no arguments.");return this},dt={clone:function(){return new ft},divideAt:function(t){var n=new R(this.start,this.end).divideAt(t);return[n[1].isDifferentiable()?new ot(n[0]):this.clone(),new ot(n[1])]},divideAtLength:function(t){var n=new R(this.start,this.end).divideAtLength(t);return[n[1].isDifferentiable()?new ot(n[0]):this.clone(),new ot(n[1])]},getSubdivisions:function(){return[]},isDifferentiable:function(){return!(!this.previousSegment||!this.subpathStartSegment)&&!this.start.equals(this.end)},round:function(){return this},scale:function(){return this},serialize:function(){return this.type},toString:function(){return this.type+" "+this.start+" "+this.end},translate:function(){return this}};Object.defineProperty(dt,"end",{configurable:!0,enumerable:!0,get:function(){if(!this.subpathStartSegment)throw new Error("Missing subpath start segment. (This segment needs a subpath start segment (e.g. Moveto); OR segment has not yet been added to a path.)");return this.subpathStartSegment.end}}),Object.defineProperty(dt,"type",{configurable:!0,enumerable:!0,value:"Z"}),ft.prototype=et(st,R.prototype,dt);var gt=it.segmentTypes={L:ot,C:ut,M:ct,Z:ft,z:ft};it.regexSupportedData=new RegExp("^[\\s\\d"+Object.keys(gt).join("")+",.]*$"),it.isDataSupported=function(t){return"string"==typeof t&&this.regexSupportedData.test(t)};var vt={curveThroughPoints:function(t){return console.warn("deprecated"),new it(nt.throughPoints(t)).serialize()},getCurveControlPoints:function(t){console.warn("deprecated");var n,e=[],i=[],r=t.length-1;if(1==r)return e[0]=new E((2*t[0].x+t[1].x)/3,(2*t[0].y+t[1].y)/3),i[0]=new E(2*e[0].x-t[0].x,2*e[0].y-t[0].y),[e,i];var s=[];for(n=1;n<r-1;n++)s[n]=4*t[n].x+2*t[n+1].x;s[0]=t[0].x+2*t[1].x,s[r-1]=(8*t[r-1].x+t[r].x)/2;var o=this.getFirstControlPoints(s);for(n=1;n<r-1;++n)s[n]=4*t[n].y+2*t[n+1].y;s[0]=t[0].y+2*t[1].y,s[r-1]=(8*t[r-1].y+t[r].y)/2;var h=this.getFirstControlPoints(s);for(n=0;n<r;n++)e.push(new E(o[n],h[n])),n<r-1?i.push(new E(2*t[n+1].x-o[n+1],2*t[n+1].y-h[n+1])):i.push(new E((t[r].x+o[r-1])/2,(t[r].y+h[r-1])/2));return[e,i]},getCurveDivider:function(t,n,e,i){console.warn("deprecated");var r=new nt(t,n,e,i);return function(t){var n=r.divide(t);return[{p0:n[0].start,p1:n[0].controlPoint1,p2:n[0].controlPoint2,p3:n[0].end},{p0:n[1].start,p1:n[1].controlPoint1,p2:n[1].controlPoint2,p3:n[1].end}]}},getFirstControlPoints:function(t){console.warn("deprecated");var n=t.length,e=[],i=[],r=2;e[0]=t[0]/r;for(var s=1;s<n;s++)i[s]=1/r,r=(s<n-1?4:3.5)-i[s],e[s]=(t[s]-e[s-1])/r;for(s=1;s<n;s++)e[n-s-1]-=i[n-s]*e[n-s];return e},getInversionSolver:function(t,n,e,i){console.warn("deprecated");var r=new nt(t,n,e,i);return function(t){return r.closestPointT(t)}}},pt=function(t){return this instanceof pt?"string"==typeof t?new pt.parse(t):void(this.points=Array.isArray(t)?t.map(E):[]):new pt(t)};function yt(t,n){var e=t.start.x,i=t.start.y,r=t.end.x,s=t.end.y,o=n.start.x,h=n.start.y,u=r-e,a=s-i,c=n.end.x-o,l=n.end.y-h,f=e-o,d=i-h,g=u*l-c*a,v=(u*d-a*f)/g,p=(c*d-l*f)/g;return 0<=v&&v<=1&&0<=p&&p<=1}function wt(t,n){var e=t.a,i=t.b,r=t.x,s=t.y,o=n.start.x-r,h=n.end.x-r,u=n.start.y-s,a=e*e,c=i*i,l=h-o,f=n.end.y-s-u,d=l*l/a+f*f/c,g=2*o*l/a+2*u*f/c,v=g*g-4*d*(o*o/a+u*u/c-1);if(0===v){var p=-g/2/d;return 0<=p&&p<=1}if(0<v){var y=Math.sqrt(v),w=(-g+y)/2/d,m=(-g-y)/2/d;return 0<=w&&w<=1||0<=m&&m<=1}return!1}function mt(t,n){return function(t,n,e,i){var r=Math.cos,s=Math.sin,o=s(n),h=r(n),u=s(i),a=r(i),c=o*o,l=h*h,f=o*h,d=u*u,g=a*a,v=u*a,p=t.a*t.a,y=t.b*t.b,w=e.a*e.a,m=e.b*e.b,x=p*c+y*l,b=w*d+m*g,S=p*l+y*c,P=w*g+m*d,A=2*(y-p)*f,L=2*(m-w)*v,E=-2*x*t.x-A*t.y,T=-2*b*e.x-L*e.y,I=-A*t.x-2*S*t.y,C=-L*e.x-2*P*e.y,R=x*t.x*t.x+S*t.y*t.y+A*t.x*t.y-p*y,D=b*e.x*e.x+P*e.y*e.y+L*e.x*e.y-w*m;L/=2,T/=2,C/=2;var M=Ut([[x,A/=2,E/=2],[A,S,I/=2],[E,I,R]]),O=Ut([[b,L,T],[L,P,C],[T,C,D]]),N=.33333333*(Ut([[b,A,E],[L,S,I],[T,I,R]])+Ut([[x,L,E],[A,P,I],[E,C,R]])+Ut([[x,A,T],[A,S,C],[E,I,D]])),q=.33333333*(Ut([[x,L,T],[A,P,C],[E,C,D]])+Ut([[b,A,T],[L,S,C],[T,I,D]])+Ut([[b,L,E],[L,P,I],[T,C,R]])),z=Gt([[M,N],[N,q]]),W=Gt([[M,q],[N,O]]),j=Gt([[N,q],[q,O]]);if(0<Gt([[2*z,W],[W,2*j]])&&(0<q||0<N))return!1;return!0}(t,0,n,0)}function xt(t,n){var e=n.start,i=n.end,r=t.x,s=t.y,o=t.width,h=t.height;return!(e.x>r+o&&i.x>r+o||e.x<r&&i.x<r||e.y>s+h&&i.y>s+h||e.y<s&&i.y<s)&&(!(!t.containsPoint(n.start)&&!t.containsPoint(n.end))||(yt(t.topLine(),n)||yt(t.rightLine(),n)||yt(t.bottomLine(),n)||yt(t.leftLine(),n)))}function bt(t,n){return!!St(t,G.fromEllipse(n))&&It(pt.fromRect(t),n)}function St(t,n){return t.x<n.x+n.width&&t.x+t.width>n.x&&t.y<n.y+n.height&&t.y+t.height>n.y}function Pt(t,n){return jt(t,n,{interior:!1})}function At(t,n){return kt(t,n,{interior:!1})}function Lt(t,n){return Vt(t,n,{interior:!1})}function Et(t,n){return Zt(t,n,{interior:!1})}function Tt(t,n){return jt(t,n,{interior:!0})}function It(t,n){return kt(t,n,{interior:!0})}function Ct(t,n){return Vt(t,n,{interior:!0})}function Rt(t,n){return Zt(t,n,{interior:!0})}function Dt(t,n){return Bt(t,n,{interior:!0})}function Mt(t,e,i){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?Tt(n,e):Pt(n,e)})}function Ot(t,e,i){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?It(n,e):At(n,e)})}function Nt(t,n,e){return zt(t,pt.fromRect(n),e)}function qt(t,n,e){return Ft(t,n,e,{interior:!1})}function zt(t,n,e){return Ft(t,n,e,{interior:!0})}function Wt(t,e,i,r){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?zt(e,n,r):qt(e,n,r)})}function jt(t,n,e){void 0===e&&(e={});var i,r=e.interior;if(void 0===r&&(r=!1),r){if(t.containsPoint(n.start))return!0;var s=t.start,o=t.end,h=t.points;i=o.equals(s)?h:h.concat([s])}else i=t.points;for(var u=i.length,a=new R,c=0;c<u-1;c++)if(a.start=i[c],a.end=i[c+1],yt(n,a))return!0;return!1}function kt(t,n,e){void 0===e&&(e={});var i,r=t.start,s=t.end,o=t.points;if(n.containsPoint(r))return!0;var h=e.interior;if(void 0===h&&(h=!1),h){if(t.containsPoint(n.center()))return!0;i=s.equals(r)?o:o.concat([r])}else i=o;for(var u=i.length,a=new R,c=0;c<u-1;c++)if(a.start=i[c],a.end=i[c+1],wt(n,a))return!0;return!1}function Vt(t,n,e){return Bt(t,pt.fromRect(n),e)}function Ft(t,e,i,r){return t.getSubpaths().some(function(t){var n=t.toPolylines(i)[0];return"Z"===t.getSegment(-1).type?Bt(e,n,r):Zt(e,n,r)})}function Zt(t,n,e){void 0===e&&(e={});var i,r=e.interior;if(void 0===r&&(r=!1),r){var s=n.start;if(t.containsPoint(s))return!0;i=t.clone().close()}else i=t;for(var o=n.points,h=o.length,u=new R,a=0;a<h-1;a++)if(u.start=o[a],u.end=o[a+1],Pt(i,u))return!0;return!1}function Bt(t,n,e){return n.containsPoint(t.start)||Zt(t,n.clone().close(),e)}function Gt(t){return t[0][0]*t[1][1]-t[0][1]*t[1][0]}function Ut(t){return t[0][0]*t[1][1]*t[2][2]-t[0][0]*t[1][2]*t[2][1]-t[0][1]*t[1][0]*t[2][2]+t[0][1]*t[1][2]*t[2][0]+t[0][2]*t[1][0]*t[2][1]-t[0][2]*t[1][1]*t[2][0]}pt.parse=function(t){return new pt(X(t))},pt.fromRect=function(t){return new pt([t.topLeft(),t.topRight(),t.bottomRight(),t.bottomLeft()])},pt.prototype=et(J.prototype,{type:v.Polygon,clone:function(){return new pt(Y(this.points))},convexHull:function(){return new pt(H(this.points))},lengthPoints:function(){var t=this.start,n=this.end,e=this.points;return e.length<=1||t.equals(n)?e:e.concat([t.clone()])}});var Xt={exists:function t(n,e,i,r){switch(n.type){case v.Line:switch(e.type){case v.Line:return yt(n,e)}break;case v.Ellipse:switch(e.type){case v.Line:return wt(n,e);case v.Ellipse:return mt(n,e)}break;case v.Rect:switch(e.type){case v.Line:return xt(n,e);case v.Ellipse:return bt(n,e);case v.Rect:return St(n,e)}break;case v.Polyline:switch(e.type){case v.Line:return Pt(n,e);case v.Ellipse:return At(n,e);case v.Rect:return Lt(n,e);case v.Polyline:return Et(n,e)}break;case v.Polygon:switch(e.type){case v.Line:return Tt(n,e);case v.Ellipse:return It(n,e);case v.Rect:return Ct(n,e);case v.Polyline:return Rt(n,e);case v.Polygon:return Dt(n,e)}break;case v.Path:switch(e.type){case v.Line:return Mt(n,e,i);case v.Ellipse:return Ot(n,e,i);case v.Rect:return Nt(n,e,i);case v.Polyline:return qt(n,e,i);case v.Polygon:return zt(n,e,i);case v.Path:return Wt(n,e,i,r)}}switch(e.type){case v.Ellipse:case v.Rect:case v.Polyline:case v.Polygon:case v.Path:return t(e,n,r,i);default:throw Error("The intersection for "+n+" and "+e+" could not be found.")}},lineWithLine:yt,ellipseWithLine:wt,ellipseWithEllipse:mt,rectWithLine:xt,rectWithEllipse:bt,rectWithRect:St,polylineWithLine:Pt,polylineWithEllipse:At,polylineWithRect:Lt,polylineWithPolyline:Et,polygonWithLine:Tt,polygonWithEllipse:It,polygonWithRect:Ct,polygonWithPolyline:Rt,polygonWithPolygon:Dt,pathWithLine:Mt,pathWithEllipse:Ot,pathWithRect:Nt,pathWithPolyline:qt,pathWithPolygon:zt,pathWithPath:Wt};t.Curve=nt,t.Ellipse=q,t.Line=R,t.Path=it,t.Point=E,t.Polygon=pt,t.Polyline=J,t.Rect=G,t.bezier=vt,t.ellipse=z,t.intersection=Xt,t.line=D,t.normalizeAngle=o,t.point=T,t.random=h,t.rect=U,t.scale={linear:function(t,n,e){var i=t[1]-t[0],r=n[1]-n[0];return(e-t[0])/i*r+n[0]||0}},t.snapToGrid=s,t.toDeg=c,t.toRad=l,t.types=v,Object.defineProperty(t,"__esModule",{value:!0})});